/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.graph.value;

import java.io.IOException;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.value.ValueType;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.util.E;

public class NullValue
implements Value.Tvalue<Void> {
    private static final NullValue INSTANCE = new NullValue();

    private NullValue() {
    }

    public static NullValue get() {
        return INSTANCE;
    }

    @Override
    public Void value() {
        return null;
    }

    @Override
    public String string() {
        return "";
    }

    @Override
    public ValueType valueType() {
        return ValueType.NULL;
    }

    @Override
    public void assign(Value other) {
        this.checkAssign(other);
    }

    @Override
    public NullValue copy() {
        return this;
    }

    @Override
    public void write(RandomAccessOutput out) throws IOException {
    }

    @Override
    public void read(RandomAccessInput in) throws IOException {
    }

    @Override
    public int compareTo(Value obj) {
        E.checkArgumentNotNull(obj, "The compare argument can't be null", new Object[0]);
        int typeDiff = this.valueType().compareTo(obj.valueType());
        if (typeDiff != 0) {
            return typeDiff;
        }
        assert (obj instanceof NullValue);
        return 0;
    }

    public boolean equals(Object obj) {
        return obj == INSTANCE || obj instanceof NullValue;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return "<null>";
    }
}

