/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.store.entry;

import java.io.IOException;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.io.IOFactory;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.computer.core.store.entry.Pointer;
import org.apache.hugegraph.computer.core.util.BytesUtil;

public class InlinePointer
implements Pointer {
    private final long length;
    private final byte[] bytes;

    public InlinePointer(byte[] bytes) {
        this.length = bytes.length;
        this.bytes = bytes;
    }

    public InlinePointer(byte[] bytes, long length) {
        this.length = length;
        this.bytes = bytes;
    }

    @Override
    public RandomAccessInput input() {
        return IOFactory.createBytesInput(this.bytes);
    }

    @Override
    public byte[] bytes() {
        return this.bytes;
    }

    @Override
    public void write(RandomAccessOutput output) throws IOException {
        output.writeFixedInt((int)this.length);
        output.write(this.bytes(), 0, (int)this.length);
    }

    @Override
    public long offset() {
        return 0L;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public int compareTo(Pointer other) {
        try {
            return BytesUtil.compare((byte[])this.bytes(), (int)((int)this.length), (byte[])other.bytes(), (int)((int)other.length()));
        }
        catch (IOException e) {
            throw new ComputerException(e.getMessage(), (Throwable)e);
        }
    }
}

