/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.sort.flusher;

import org.apache.hugegraph.computer.core.sort.flusher.PeekableIterator;
import org.apache.hugegraph.iterator.CIter;
import org.apache.hugegraph.util.E;

public class PeekableIteratorAdaptor<T>
implements PeekableIterator<T> {
    private final CIter<T> entries;
    private T next;

    private PeekableIteratorAdaptor(CIter<T> entries) {
        this.entries = entries;
        this.fetchNext();
    }

    public static <T> PeekableIterator<T> of(CIter<T> iterator) {
        E.checkArgument((boolean)iterator.hasNext(), (String)"Parameter iterator can't be empty", (Object[])new Object[0]);
        return new PeekableIteratorAdaptor<T>(iterator);
    }

    @Override
    public T peek() {
        return this.next;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public T next() {
        T next = this.next;
        this.fetchNext();
        return next;
    }

    private void fetchNext() {
        this.next = this.entries.hasNext() ? this.entries.next() : null;
    }

    public void close() throws Exception {
        this.entries.close();
    }

    public Object metadata(String s, Object ... objects) {
        return this.entries.metadata(s, objects);
    }
}

