/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.network.message;

import io.netty.buffer.ByteBuf;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.hugegraph.computer.core.network.buffer.NetworkBuffer;
import org.apache.hugegraph.computer.core.network.message.Message;

public abstract class AbstractMessage
implements Message {
    public static final int HEADER_LENGTH = 16;
    public static final int OFFSET_BODY_LENGTH = 12;
    public static final int LENGTH_BODY_LENGTH = 4;
    public static final int MAX_MESSAGE_LENGTH = Integer.MAX_VALUE;
    public static final short MAGIC_NUMBER = 18503;
    public static final byte PROTOCOL_VERSION = 1;
    public static final int UNKNOWN_SEQ = -1;
    public static final int START_SEQ = 0;
    private final int sequenceNumber;
    private final int partition;
    private final int bodyLength;
    private final NetworkBuffer body;

    protected AbstractMessage() {
        this(-1);
    }

    protected AbstractMessage(int sequenceNumber) {
        this(sequenceNumber, 0);
    }

    protected AbstractMessage(int sequenceNumber, int partition) {
        this(sequenceNumber, partition, null);
    }

    protected AbstractMessage(int sequenceNumber, NetworkBuffer body) {
        this(sequenceNumber, 0, body);
    }

    protected AbstractMessage(NetworkBuffer body) {
        this(-1, 0, body);
    }

    protected AbstractMessage(int sequenceNumber, int partition, NetworkBuffer body) {
        this.sequenceNumber = sequenceNumber;
        this.partition = partition;
        if (body != null) {
            this.body = body;
            this.bodyLength = body.length();
        } else {
            this.body = null;
            this.bodyLength = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkBuffer encode(ByteBuf buf) {
        int bodyLength;
        this.encodeHeader(buf);
        int bodyStart = buf.writerIndex();
        NetworkBuffer networkBuffer = this.encodeBody(buf);
        int bodyEnd = buf.writerIndex();
        if (networkBuffer != null) {
            assert (bodyStart == bodyEnd);
            bodyLength = networkBuffer.length();
        } else {
            bodyLength = bodyEnd - bodyStart;
        }
        int lastWriteIndex = buf.writerIndex();
        try {
            buf.resetWriterIndex();
            buf.writeInt(bodyLength);
        }
        finally {
            buf.writerIndex(lastWriteIndex);
        }
        return networkBuffer;
    }

    protected void encodeHeader(ByteBuf buf) {
        buf.writeShort(18503);
        buf.writeByte(1);
        buf.writeByte((int)this.type().code());
        buf.writeInt(this.sequenceNumber());
        buf.writeInt(this.partition());
        buf.markWriterIndex();
        buf.writeInt(0);
    }

    protected NetworkBuffer encodeBody(ByteBuf buf) {
        return this.body();
    }

    @Override
    public int sequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public int partition() {
        return this.partition;
    }

    @Override
    public boolean hasBody() {
        return this.body != null && this.bodyLength > 0;
    }

    @Override
    public NetworkBuffer body() {
        return this.hasBody() ? this.body : null;
    }

    @Override
    public void release() {
        if (this.hasBody()) {
            this.body.release();
        }
    }

    protected static void assertExtraHeader(ByteBuf buf) {
        int sequenceNumber = buf.readInt();
        assert (sequenceNumber == -1);
        int partition = buf.readInt();
        assert (partition == 0);
        int bodyLength = buf.readInt();
        assert (bodyLength == 0);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("messageType", (Object)this.type()).append("sequenceNumber", this.sequenceNumber()).append("partition", this.partition()).append("hasBody", this.hasBody()).append("bodyLength", this.bodyLength).toString();
    }
}

