/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.network.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.nio.ByteBuffer;
import org.apache.hugegraph.computer.core.network.buffer.NetworkBuffer;

public class NettyBuffer
implements NetworkBuffer {
    private final ByteBuf buf;

    public NettyBuffer(ByteBuf buf) {
        this.buf = buf;
    }

    @Override
    public int length() {
        return this.buf.readableBytes();
    }

    @Override
    public NetworkBuffer retain() {
        this.buf.retain();
        return this;
    }

    @Override
    public NetworkBuffer release() {
        this.buf.release();
        return this;
    }

    @Override
    public int referenceCount() {
        return this.buf.refCnt();
    }

    @Override
    public ByteBuffer nioByteBuffer() {
        return this.buf.nioBuffer();
    }

    @Override
    public ByteBuf nettyByteBuf() {
        return this.buf.duplicate();
    }

    @Override
    public byte[] copyToByteArray() {
        return ByteBufUtil.getBytes((ByteBuf)this.buf, (int)this.buf.readerIndex(), (int)this.buf.readableBytes(), (boolean)true);
    }
}

