/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.io;

import java.io.IOException;
import org.apache.hugegraph.computer.core.io.BytesInput;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.UnsafeBytesInput;
import org.apache.hugegraph.computer.core.util.CoderUtil;
import org.apache.hugegraph.util.Bytes;
import org.apache.hugegraph.util.E;

public class OptimizedBytesInput
implements BytesInput {
    private final UnsafeBytesInput in;

    public OptimizedBytesInput(byte[] buffer) {
        this(buffer, buffer.length);
    }

    public OptimizedBytesInput(byte[] buffer, int limit) {
        this(buffer, 0, limit);
    }

    public OptimizedBytesInput(byte[] buffer, int position, int limit) {
        this(new UnsafeBytesInput(buffer, position, limit));
    }

    public OptimizedBytesInput(UnsafeBytesInput in) {
        this.in = in;
    }

    public long position() {
        return this.in.position();
    }

    public void seek(long position) throws IOException {
        this.in.seek(position);
    }

    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    public long available() throws IOException {
        return this.in.available();
    }

    public OptimizedBytesInput duplicate() throws IOException {
        return new OptimizedBytesInput(this.in.duplicate());
    }

    public int compare(long offset, long length, RandomAccessInput other, long otherOffset, long otherLength) throws IOException {
        return this.in.compare(offset, length, other, otherOffset, otherLength);
    }

    public void close() throws IOException {
        this.in.close();
    }

    public void readFully(byte[] b) throws IOException {
        this.in.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.in.readFully(b, off, len);
    }

    public int skipBytes(int n) throws IOException {
        return this.in.skipBytes(n);
    }

    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.in.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    public char readChar() throws IOException {
        return this.in.readChar();
    }

    public int readInt() throws IOException {
        return this.readVInt();
    }

    public long readLong() throws IOException {
        return this.readVLong();
    }

    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    public String readLine() throws IOException {
        return this.in.readLine();
    }

    public String readUTF() throws IOException {
        return this.readString();
    }

    public int readFixedInt() throws IOException {
        return this.in.readFixedInt();
    }

    private int readVInt() throws IOException {
        int i;
        byte leading = this.readByte();
        E.checkArgument((leading != 128 ? 1 : 0) != 0, (String)"Unexpected varint with leading byte '0x%s'", (Object[])new Object[]{Bytes.toHex((byte)leading)});
        int value = leading & 0x7F;
        if (leading >= 0) {
            assert ((leading & 0x80) == 0);
            return value;
        }
        for (i = 1; i < 5; ++i) {
            byte b = this.readByte();
            if (b >= 0) {
                value = b | value << 7;
                break;
            }
            value = b & 0x7F | value << 7;
        }
        E.checkArgument((i < 5 ? 1 : 0) != 0, (String)"Unexpected varint %s with too many bytes(%s)", (Object[])new Object[]{value, i + 1});
        E.checkArgument((i < 4 || (leading & 0x70) == 0 ? 1 : 0) != 0, (String)"Unexpected varint %s with leading byte '0x%s'", (Object[])new Object[]{value, Bytes.toHex((byte)leading)});
        return value;
    }

    private long readVLong() throws IOException {
        int i;
        byte leading = this.readByte();
        E.checkArgument((leading != 128 ? 1 : 0) != 0, (String)"Unexpected varlong with leading byte '0x%s'", (Object[])new Object[]{Bytes.toHex((byte)leading)});
        long value = (long)leading & 0x7FL;
        if (leading >= 0) {
            assert ((leading & 0x80) == 0);
            return value;
        }
        for (i = 1; i < 10; ++i) {
            byte b = this.readByte();
            if (b >= 0) {
                value = (long)b | value << 7;
                break;
            }
            value = (long)(b & 0x7F) | value << 7;
        }
        E.checkArgument((i < 10 ? 1 : 0) != 0, (String)"Unexpected varlong %s with too many bytes(%s)", (Object[])new Object[]{value, i + 1});
        E.checkArgument((i < 9 || (leading & 0x7E) == 0 ? 1 : 0) != 0, (String)"Unexpected varlong %s with leading byte '0x%s'", (Object[])new Object[]{value, Bytes.toHex((byte)leading)});
        return value;
    }

    private String readString() throws IOException {
        return CoderUtil.decode((byte[])this.readBytes());
    }

    private byte[] readBytes() throws IOException {
        int length = this.readVInt();
        assert (length >= 0);
        byte[] bytes = new byte[length];
        this.readFully(bytes, 0, length);
        return bytes;
    }
}

