/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.graph.partition;

import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.graph.id.Id;
import org.apache.hugegraph.computer.core.graph.partition.Partitioner;
import org.apache.hugegraph.config.TypedOption;

public final class HashPartitioner
implements Partitioner {
    private int partitionCount = -1;
    private int workerCount = -1;

    @Override
    public void init(Config config) {
        this.partitionCount = (Integer)config.get((TypedOption)ComputerOptions.JOB_PARTITIONS_COUNT);
        this.workerCount = (Integer)config.get((TypedOption)ComputerOptions.JOB_WORKERS_COUNT);
    }

    @Override
    public int partitionId(Id vertexId) {
        int hashCode = vertexId.hashCode() & Integer.MAX_VALUE;
        return hashCode % this.partitionCount;
    }

    @Override
    public int workerId(int partitionId) {
        return partitionId % this.workerCount + 1;
    }
}

