/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.reader.file;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hugegraph.loader.exception.LoadException;
import org.apache.hugegraph.loader.reader.Readable;
import org.apache.hugegraph.loader.reader.file.FileLineFetcher;
import org.apache.hugegraph.loader.reader.line.Line;
import org.apache.hugegraph.loader.source.file.FileSource;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class OrcFileLineFetcher
extends FileLineFetcher {
    private static final Logger LOG = Log.logger(OrcFileLineFetcher.class);
    private final Configuration conf;
    private Reader reader;
    private RecordReader recordReader;
    private StructObjectInspector inspector;
    private Object row;

    public OrcFileLineFetcher(FileSource source) {
        this(source, new Configuration());
    }

    public OrcFileLineFetcher(FileSource source, Configuration conf) {
        super(source);
        this.conf = conf;
        this.reader = null;
        this.recordReader = null;
        this.inspector = null;
        this.row = null;
    }

    @Override
    public boolean ready() {
        return this.reader != null;
    }

    @Override
    public void resetReader() {
        this.reader = null;
        this.recordReader = null;
        this.inspector = null;
        this.row = null;
    }

    @Override
    public boolean needReadHeader() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] readHeader(List<Readable> readables) {
        Readable readable = readables.get(0);
        this.openReader(readable);
        try {
            StructObjectInspector inspector = (StructObjectInspector)this.reader.getObjectInspector();
            String[] stringArray = this.parseHeader(inspector);
            return stringArray;
        }
        finally {
            try {
                this.closeReader();
            }
            catch (IOException e) {
                LOG.warn("Failed to close reader of '{}'", (Object)readable);
            }
        }
    }

    @Override
    public void openReader(Readable readable) {
        Path path = readable.path();
        try {
            OrcFile.ReaderOptions options = OrcFile.readerOptions((Configuration)this.conf);
            this.reader = OrcFile.createReader((Path)path, (OrcFile.ReaderOptions)options);
            this.recordReader = this.reader.rows();
            this.inspector = (StructObjectInspector)this.reader.getObjectInspector();
            this.row = null;
        }
        catch (IOException e) {
            throw new LoadException("Failed to open orc reader for '%s'", (Throwable)e, readable);
        }
        this.resetOffset();
    }

    @Override
    public Line fetch() throws IOException {
        if (!this.recordReader.hasNext()) {
            return null;
        }
        this.row = this.recordReader.next(this.row);
        List data = this.inspector.getStructFieldsDataAsList(this.row);
        Object[] values = new Object[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            values[i] = data.get(i) == null ? "" : data.get(i).toString();
        }
        String rawLine = StringUtils.join((Object[])values, (String)",");
        this.increaseOffset();
        return new Line(rawLine, this.source().header(), values);
    }

    @Override
    public void closeReader() throws IOException {
        if (this.recordReader != null) {
            this.recordReader.close();
        }
    }

    private String[] parseHeader(StructObjectInspector inspector) {
        List fields = inspector.getAllStructFieldRefs();
        return fields.stream().map(StructField::getFieldName).collect(Collectors.toList()).toArray(new String[0]);
    }
}

