/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.base.util;

import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.apache.bifromq.base.util.CascadeCancelCompletableFuture;
import org.apache.bifromq.base.util.CompletableFutureUtil;
import org.apache.bifromq.base.util.exception.NeedRetryException;
import org.apache.bifromq.base.util.exception.RetryTimeoutException;

public class AsyncRetry {
    public static <T> CompletableFuture<T> exec(Supplier<CompletableFuture<T>> taskSupplier, long retryTimeoutNanos) {
        return AsyncRetry.exec(taskSupplier, (result, t) -> {
            if (t != null) {
                Throwable cause = t instanceof CompletionException ? t.getCause() : t;
                return cause instanceof NeedRetryException || cause != null && cause.getCause() instanceof NeedRetryException;
            }
            return false;
        }, retryTimeoutNanos / 5L, retryTimeoutNanos);
    }

    public static <T> CompletableFuture<T> exec(Supplier<CompletableFuture<T>> taskSupplier, BiPredicate<T, Throwable> retryPredicate, long initialBackoffNanos, long maxDelayNanos) {
        if (initialBackoffNanos < 0L || maxDelayNanos < 0L || initialBackoffNanos > maxDelayNanos) {
            throw new IllegalArgumentException("Invalid backoff/timeout settings");
        }
        AtomicReference current = new AtomicReference();
        AtomicBoolean cancelled = new AtomicBoolean(false);
        CancellableRetryFuture onDone = new CancellableRetryFuture(current, cancelled);
        AsyncRetry.execLoop(taskSupplier, retryPredicate, initialBackoffNanos, maxDelayNanos, 0, 0L, current, cancelled, onDone);
        return CascadeCancelCompletableFuture.fromRoot(onDone);
    }

    private static <T> void execLoop(Supplier<CompletableFuture<T>> taskSupplier, BiPredicate<T, Throwable> retryPredicate, long initialBackoffNanos, long maxDelayNanos, int retryCount, long delayNanosSoFar, AtomicReference<CompletableFuture<T>> current, AtomicBoolean cancelled, CompletableFuture<T> onDone) {
        if (cancelled.get()) {
            onDone.completeExceptionally(new CancellationException());
            return;
        }
        if (initialBackoffNanos > 0L && delayNanosSoFar >= maxDelayNanos) {
            onDone.completeExceptionally(new RetryTimeoutException("Max retry delay exceeded"));
            return;
        }
        CompletableFuture attempt = AsyncRetry.executeTask(taskSupplier);
        current.set(attempt);
        attempt.whenComplete(CompletableFutureUtil.unwrap((result, t) -> {
            long remaining;
            if (cancelled.get()) {
                attempt.cancel(true);
                return;
            }
            boolean shouldRetry = false;
            if (initialBackoffNanos > 0L) {
                try {
                    shouldRetry = retryPredicate.test((Object)result, (Throwable)t);
                }
                catch (Throwable predicateError) {
                    onDone.completeExceptionally(predicateError);
                    return;
                }
            }
            if (!shouldRetry) {
                if (t != null) {
                    onDone.completeExceptionally((Throwable)t);
                } else {
                    onDone.complete(result);
                }
                return;
            }
            long delay = initialBackoffNanos * (1L << Math.min(retryCount, 30));
            if (delay > (remaining = maxDelayNanos - delayNanosSoFar)) {
                delay = remaining;
            }
            long nextDelaySoFar = delayNanosSoFar + delay;
            Executor delayExecutor = CompletableFuture.delayedExecutor(delay, TimeUnit.NANOSECONDS);
            CompletableFuture.runAsync(() -> AsyncRetry.lambda$execLoop$1((Supplier)taskSupplier, retryPredicate, initialBackoffNanos, maxDelayNanos, retryCount, nextDelaySoFar, current, cancelled, onDone), delayExecutor);
        }));
    }

    private static <T> CompletableFuture<T> executeTask(Supplier<CompletableFuture<T>> taskSupplier) {
        try {
            return Objects.requireNonNull(taskSupplier.get(), "taskSupplier returned null CompletableFuture");
        }
        catch (Throwable e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private static /* synthetic */ void lambda$execLoop$1(Supplier taskSupplier, BiPredicate retryPredicate, long initialBackoffNanos, long maxDelayNanos, int retryCount, long nextDelaySoFar, AtomicReference current, AtomicBoolean cancelled, CompletableFuture onDone) {
        AsyncRetry.execLoop(taskSupplier, retryPredicate, initialBackoffNanos, maxDelayNanos, retryCount + 1, nextDelaySoFar, current, cancelled, onDone);
    }

    private static final class CancellableRetryFuture<T>
    extends CompletableFuture<T> {
        private final AtomicReference<CompletableFuture<T>> currentTask;
        private final AtomicBoolean cancelled;

        CancellableRetryFuture(AtomicReference<CompletableFuture<T>> currentTask, AtomicBoolean cancelled) {
            this.currentTask = currentTask;
            this.cancelled = cancelled;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.cancelled.set(true);
            CompletableFuture<T> inFlight = this.currentTask.get();
            if (inFlight != null) {
                inFlight.cancel(mayInterruptIfRunning);
            }
            return super.cancel(mayInterruptIfRunning);
        }
    }
}

