/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.sysprops.parser;

import org.apache.bifromq.sysprops.parser.PropParser;
import org.apache.bifromq.sysprops.parser.SysPropParseException;

public class DoubleParser
implements PropParser<Double> {
    private final double lowBound;
    private final boolean excludeLowerBound;
    private final double highBoundEx;

    private DoubleParser(double lowBound, double highBoundEx, boolean excludeLowerBound) {
        this.lowBound = lowBound;
        this.highBoundEx = highBoundEx;
        this.excludeLowerBound = excludeLowerBound;
    }

    @Override
    public Double parse(String value) {
        double val = Double.parseDouble(value);
        int isLower = Double.compare(this.lowBound, val);
        if ((this.excludeLowerBound ? isLower < 0 : isLower <= 0) && Double.compare(val, this.highBoundEx) < 0) {
            return val;
        }
        if (this.excludeLowerBound) {
            throw new SysPropParseException(String.format("%f is out of bound (%f,%f)", val, this.lowBound, this.highBoundEx));
        }
        throw new SysPropParseException(String.format("%f is out of bound [%f,%f)", val, this.lowBound, this.highBoundEx));
    }

    public static DoubleParser from(double lowBound, double highBoundEx, boolean excludeLowerBound) {
        assert (Double.compare(lowBound, highBoundEx) < 0);
        return new DoubleParser(lowBound, highBoundEx, excludeLowerBound);
    }
}

