/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.rocksdb;

import com.google.common.base.Strings;
import com.google.protobuf.Struct;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.bifromq.basekv.localengine.AbstractKVEngine;
import org.apache.bifromq.basekv.localengine.KVEngineException;
import org.apache.bifromq.basekv.localengine.StructUtil;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBKVSpace;
import org.rocksdb.RocksDB;

abstract class RocksDBKVEngine<T extends RocksDBKVSpace>
extends AbstractKVEngine<T> {
    public static final String IDENTITY_FILE = "IDENTITY";
    private final File dbRootDir;
    private final String identity;
    private final boolean isCreate;
    private MetricManager metricManager;

    public RocksDBKVEngine(String overrideIdentity, Struct confRoot) {
        super(overrideIdentity, confRoot);
        this.dbRootDir = new File(StructUtil.strVal((Struct)this.engineConf, (String)"dbRootDir"));
        try {
            Files.createDirectories(this.dbRootDir.getAbsoluteFile().toPath(), new FileAttribute[0]);
            this.isCreate = RocksDBKVEngine.isEmpty(this.dbRootDir.toPath());
            this.identity = this.loadIdentity(this.isCreate);
        }
        catch (Throwable e) {
            throw new KVEngineException("Failed to initialize RocksDBKVEngine", e);
        }
    }

    private static boolean isEmpty(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (Stream<Path> entries = Files.list(path);){
                boolean bl = entries.findFirst().isEmpty();
                return bl;
            }
        }
        return false;
    }

    protected void doStart(String ... tags) {
        this.log.info("RocksDBKVEngine[{}] {} at path[{}]", new Object[]{this.identity, this.isCreate ? "initialized" : "loaded", this.dbRootDir.getName()});
        this.loadExisting(tags);
        this.metricManager = new MetricManager(tags);
    }

    protected void afterStart() {
        super.afterStart();
    }

    protected void doStop() {
        this.log.info("Stopping RocksDBKVEngine[{}]", (Object)this.identity);
        super.doStop();
        this.metricManager.close();
    }

    public String id() {
        return this.identity;
    }

    private void loadExisting(String ... metricTags) {
        try (Stream<Path> paths = Files.list(Paths.get(this.dbRootDir.getAbsolutePath(), new String[0]));){
            paths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(Path::getFileName).map(Path::toString).forEach(x$0 -> this.load((String)x$0));
        }
        catch (Throwable e) {
            this.log.error("Failed to load existing key spaces", e);
        }
    }

    private String loadIdentity(boolean create) {
        try {
            Path identityFilePath = Paths.get(this.dbRootDir.getAbsolutePath(), IDENTITY_FILE);
            if (create) {
                String identity = Strings.isNullOrEmpty((String)this.overrideIdentity) ? UUID.randomUUID().toString() : this.overrideIdentity.trim();
                Files.writeString(identityFilePath, (CharSequence)identity, StandardOpenOption.CREATE);
            }
            return Files.readAllLines(identityFilePath).get(0);
        }
        catch (IOException | IndexOutOfBoundsException e) {
            throw new KVEngineException("Failed to read IDENTITY file", (Throwable)e);
        }
    }

    static {
        RocksDB.loadLibrary();
    }

    private class MetricManager {
        private final Gauge dataTotalSpaceGauge;
        private final Gauge dataUsableSpaceGauge;

        MetricManager(String ... metricTags) {
            Tags tags = Tags.of((String[])metricTags);
            this.dataTotalSpaceGauge = Gauge.builder((String)"basekv.le.rocksdb.total.data", RocksDBKVEngine.this.dbRootDir::getTotalSpace).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
            this.dataUsableSpaceGauge = Gauge.builder((String)"basekv.le.rocksdb.usable.data", RocksDBKVEngine.this.dbRootDir::getUsableSpace).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        }

        void close() {
            Metrics.globalRegistry.remove((Meter)this.dataTotalSpaceGauge);
            Metrics.globalRegistry.remove((Meter)this.dataUsableSpaceGauge);
        }
    }
}

