/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.rocksdb;

import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;

class Keys {
    public static final byte[] LATEST_CP_KEY = new byte[]{1};
    public static final byte[] META_SECTION_START = new byte[]{2};
    public static final byte[] META_SECTION_END = new byte[]{3};
    private static final ByteString METADATA_PREFIX = UnsafeByteOperations.unsafeWrap((byte[])new byte[]{2});
    private static final ByteString DATA_PREFIX = UnsafeByteOperations.unsafeWrap((byte[])new byte[]{-2});
    public static final byte[] DATA_SECTION_START = new byte[]{-2};
    public static final byte[] DATA_SECTION_END = new byte[]{-1};

    Keys() {
    }

    public static byte[] toDataKey(ByteString key) {
        return DATA_PREFIX.concat(key).toByteArray();
    }

    public static ByteString fromDataKey(byte[] rawKey) {
        return UnsafeByteOperations.unsafeWrap((byte[])rawKey).substring(DATA_PREFIX.size());
    }

    public static byte[] toDataKey(byte[] key) {
        return DATA_PREFIX.concat(UnsafeByteOperations.unsafeWrap((byte[])key)).toByteArray();
    }

    public static byte[] toMetaKey(ByteString key) {
        return METADATA_PREFIX.concat(key).toByteArray();
    }

    public static ByteString fromMetaKey(byte[] rawKey) {
        return UnsafeByteOperations.unsafeWrap((byte[])rawKey).substring(METADATA_PREFIX.size());
    }
}

