/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.store.delay;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.inbox.client.IInboxClient;
import org.apache.bifromq.inbox.record.TenantInboxInstance;
import org.apache.bifromq.inbox.rpc.proto.DeleteReply;
import org.apache.bifromq.inbox.rpc.proto.DeleteRequest;
import org.apache.bifromq.inbox.storage.proto.InboxVersion;
import org.apache.bifromq.inbox.store.delay.IDelayTaskRunner;
import org.apache.bifromq.inbox.store.delay.RetryableDelayedTask;

public class ExpireInboxTask
extends RetryableDelayedTask<DeleteReply> {
    private final IInboxClient inboxClient;

    public ExpireInboxTask(Duration delay, long mod, IInboxClient inboxClient) {
        this(delay, mod, inboxClient, 0);
    }

    private ExpireInboxTask(Duration delay, long version, IInboxClient inboxClient, int retryCount) {
        super(delay, version, retryCount);
        this.inboxClient = inboxClient;
    }

    @Override
    protected CompletableFuture<DeleteReply> callOperation(TenantInboxInstance key, IDelayTaskRunner<TenantInboxInstance> runner) {
        return this.inboxClient.delete(DeleteRequest.newBuilder().setReqId(System.nanoTime()).setTenantId(key.tenantId()).setInboxId(key.instance().inboxId()).setVersion(InboxVersion.newBuilder().setIncarnation(key.instance().incarnation()).setMod(this.mod).build()).build());
    }

    @Override
    protected boolean shouldRetry(DeleteReply reply) {
        return reply.getCode() == DeleteReply.Code.TRY_LATER || reply.getCode() == DeleteReply.Code.BACK_PRESSURE_REJECTED;
    }

    @Override
    protected RetryableDelayedTask<DeleteReply> createRetryTask(Duration newDelay) {
        return new ExpireInboxTask(newDelay, this.mod, this.inboxClient, this.retryCount + 1);
    }

    @Override
    protected String getTaskName() {
        return "Expire inbox";
    }
}

