/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.server.scheduler;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.bifromq.basekv.client.IBaseKVStoreClient;
import org.apache.bifromq.basekv.client.scheduler.BatchQueryCall;
import org.apache.bifromq.basekv.client.scheduler.IBatchQueryCallBuilder;
import org.apache.bifromq.basekv.client.scheduler.QueryCallScheduler;
import org.apache.bifromq.sysprops.props.DataPlaneMaxBurstLatencyMillis;

public abstract class InboxReadScheduler<ReqT, RespT, InboxBatchQueryT extends BatchQueryCall<ReqT, RespT>>
extends QueryCallScheduler<ReqT, RespT, InboxBatchQueryT> {
    protected final int queuesPerRange;

    public InboxReadScheduler(IBatchQueryCallBuilder<ReqT, RespT, InboxBatchQueryT> batchQueryCallBuilder, int queuesPerRange, IBaseKVStoreClient inboxStoreClient) {
        super(batchQueryCallBuilder, Duration.ofMillis((Long)DataPlaneMaxBurstLatencyMillis.INSTANCE.get()).toNanos(), inboxStoreClient);
        Preconditions.checkArgument((queuesPerRange > 0 ? 1 : 0) != 0, (Object)"Queues per range must be positive");
        this.queuesPerRange = queuesPerRange;
    }

    protected int selectQueue(ReqT request) {
        return ThreadLocalRandom.current().nextInt(0, this.queuesPerRange);
    }
}

