/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.storage.geopackage;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageManager;
import org.apache.baremaps.database.schema.DataSchema;
import org.apache.baremaps.database.schema.DataTable;
import org.apache.baremaps.database.schema.DataTableException;
import org.apache.baremaps.storage.geopackage.GeoPackageDataTable;

public class GeoPackageDataSchema
implements DataSchema,
AutoCloseable {
    private final GeoPackage geoPackage;

    public GeoPackageDataSchema(Path file) {
        this.geoPackage = GeoPackageManager.open((File)file.toFile());
    }

    @Override
    public void close() throws Exception {
        this.geoPackage.close();
    }

    @Override
    public Collection<String> list() throws DataTableException {
        return this.geoPackage.getFeatureTables();
    }

    @Override
    public DataTable get(String name) throws DataTableException {
        return new GeoPackageDataTable(this.geoPackage.getFeatureDao(name));
    }

    @Override
    public void add(DataTable value) throws DataTableException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(String name) throws DataTableException {
        throw new UnsupportedOperationException();
    }
}

