/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.function;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.baremaps.database.collection.DataMap;
import org.apache.baremaps.openstreetmap.model.Element;
import org.apache.baremaps.openstreetmap.model.Entity;
import org.locationtech.jts.geom.Geometry;

public class GeometryMapBuilder
implements Consumer<Entity> {
    private final DataMap<Long, Geometry> geometryMap;
    private final Predicate<Entity> filter;

    public GeometryMapBuilder(DataMap<Long, Geometry> geometryMap, Predicate<Entity> filter) {
        this.geometryMap = geometryMap;
        this.filter = filter;
    }

    @Override
    public void accept(Entity entity) {
        if (this.filter.test(entity) && entity instanceof Element) {
            Element element = (Element)entity;
            this.geometryMap.put(element.getId(), element.getGeometry());
        }
    }
}

