/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.internal.server.RouteDecoratingService;
import com.linecorp.armeria.internal.server.RouteUtil;
import com.linecorp.armeria.internal.server.annotation.AnnotatedServiceExtensions;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.AbstractContextPathAnnotatedServiceConfigSetters;
import com.linecorp.armeria.server.AbstractContextPathDecoratingBindingBuilder;
import com.linecorp.armeria.server.AbstractContextPathServiceBindingBuilder;
import com.linecorp.armeria.server.DecoratingHttpServiceFunction;
import com.linecorp.armeria.server.FunctionalDecoratingHttpService;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.HttpServiceWithRoutes;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.ServiceConfigBuilder;
import com.linecorp.armeria.server.ServiceConfigSetters;
import com.linecorp.armeria.server.ServiceConfigsBuilder;
import com.linecorp.armeria.server.VirtualHostBuilder;
import com.linecorp.armeria.server.annotation.ExceptionHandlerFunction;
import com.linecorp.armeria.server.annotation.RequestConverterFunction;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

abstract class AbstractContextPathServicesBuilder<T extends ServiceConfigsBuilder>
implements ServiceConfigsBuilder {
    private final Set<String> contextPaths;
    private final T parent;
    private final VirtualHostBuilder virtualHostBuilder;

    AbstractContextPathServicesBuilder(T parent, VirtualHostBuilder virtualHostBuilder, Set<String> contextPaths) {
        Preconditions.checkArgument(!contextPaths.isEmpty(), "At least one context path is required");
        for (String contextPath : contextPaths) {
            RouteUtil.ensureAbsolutePath(contextPath, "contextPath");
        }
        this.parent = parent;
        this.contextPaths = ImmutableSet.copyOf(contextPaths);
        this.virtualHostBuilder = virtualHostBuilder;
    }

    @Override
    public abstract AbstractContextPathServiceBindingBuilder<T> route();

    @Override
    public abstract AbstractContextPathDecoratingBindingBuilder<T> routeDecorator();

    @Override
    public AbstractContextPathServicesBuilder<T> serviceUnder(String pathPrefix, HttpService service) {
        Objects.requireNonNull(pathPrefix, "pathPrefix");
        Objects.requireNonNull(service, "service");
        HttpServiceWithRoutes serviceWithRoutes = service.as(HttpServiceWithRoutes.class);
        if (serviceWithRoutes != null) {
            serviceWithRoutes.routes().forEach(route -> {
                for (String contextPath : this.contextPaths) {
                    ServiceConfigBuilder serviceConfigBuilder = new ServiceConfigBuilder(route.withPrefix(pathPrefix), contextPath, service);
                    serviceConfigBuilder.addMappedRoute((Route)route);
                    this.addServiceConfigSetters(serviceConfigBuilder);
                }
            });
        } else {
            this.service(Route.builder().pathPrefix(pathPrefix).build(), service);
        }
        return this;
    }

    @Override
    public AbstractContextPathServicesBuilder<T> service(String pathPattern, HttpService service) {
        return this.service(Route.builder().path(pathPattern).build(), service);
    }

    @Override
    public AbstractContextPathServicesBuilder<T> service(Route route, HttpService service) {
        for (String contextPath : this.contextPaths) {
            this.addServiceConfigSetters(new ServiceConfigBuilder(route, contextPath, service));
        }
        return this;
    }

    @Override
    public AbstractContextPathServicesBuilder<T> service(HttpServiceWithRoutes serviceWithRoutes, Iterable<? extends Function<? super HttpService, ? extends HttpService>> decorators) {
        Objects.requireNonNull(serviceWithRoutes, "serviceWithRoutes");
        Objects.requireNonNull(serviceWithRoutes.routes(), "serviceWithRoutes.routes()");
        Objects.requireNonNull(decorators, "decorators");
        HttpService decorated = ServerBuilder.decorate(serviceWithRoutes, decorators);
        serviceWithRoutes.routes().forEach(route -> this.service((Route)route, decorated));
        return this;
    }

    @Override
    public AbstractContextPathServicesBuilder<T> service(HttpServiceWithRoutes serviceWithRoutes, Function<? super HttpService, ? extends HttpService> ... decorators) {
        return this.service(serviceWithRoutes, ImmutableList.copyOf(Objects.requireNonNull(decorators, "decorators")));
    }

    @Override
    public AbstractContextPathServicesBuilder<T> annotatedService(Object service) {
        return this.annotatedService("/", service, Function.identity(), (Iterable)ImmutableList.of());
    }

    @Override
    public AbstractContextPathServicesBuilder<T> annotatedService(Object service, Object ... exceptionHandlersAndConverters) {
        return this.annotatedService("/", service, Function.identity(), ImmutableList.copyOf(Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters")));
    }

    @Override
    public AbstractContextPathServicesBuilder<T> annotatedService(Object service, Function<? super HttpService, ? extends HttpService> decorator, Object ... exceptionHandlersAndConverters) {
        return this.annotatedService("/", service, (Function)decorator, ImmutableList.copyOf(Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters")));
    }

    @Override
    public AbstractContextPathServicesBuilder<T> annotatedService(String pathPrefix, Object service) {
        return this.annotatedService(pathPrefix, service, Function.identity(), (Iterable)ImmutableList.of());
    }

    @Override
    public AbstractContextPathServicesBuilder<T> annotatedService(String pathPrefix, Object service, Object ... exceptionHandlersAndConverters) {
        return this.annotatedService(pathPrefix, service, Function.identity(), ImmutableList.copyOf(Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters")));
    }

    @Override
    public AbstractContextPathServicesBuilder<T> annotatedService(String pathPrefix, Object service, Function<? super HttpService, ? extends HttpService> decorator, Object ... exceptionHandlersAndConverters) {
        return this.annotatedService(pathPrefix, service, (Function)decorator, ImmutableList.copyOf(Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters")));
    }

    @Override
    public AbstractContextPathServicesBuilder<T> annotatedService(String pathPrefix, Object service, Iterable<?> exceptionHandlersAndConverters) {
        return this.annotatedService(pathPrefix, service, Function.identity(), (Iterable)Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters"));
    }

    @Override
    public AbstractContextPathServicesBuilder<T> annotatedService(String pathPrefix, Object service, Function<? super HttpService, ? extends HttpService> decorator, Iterable<?> exceptionHandlersAndConverters) {
        Objects.requireNonNull(pathPrefix, "pathPrefix");
        Objects.requireNonNull(service, "service");
        Objects.requireNonNull(decorator, "decorator");
        Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters");
        AnnotatedServiceExtensions configurator = AnnotatedServiceExtensions.ofExceptionHandlersAndConverters(exceptionHandlersAndConverters);
        return this.annotatedService(pathPrefix, service, (Function)decorator, configurator.exceptionHandlers(), configurator.requestConverters(), configurator.responseConverters());
    }

    @Override
    public abstract AbstractContextPathServicesBuilder<T> annotatedService(String var1, Object var2, Function<? super HttpService, ? extends HttpService> var3, Iterable<? extends ExceptionHandlerFunction> var4, Iterable<? extends RequestConverterFunction> var5, Iterable<? extends ResponseConverterFunction> var6);

    @Override
    public abstract AbstractContextPathAnnotatedServiceConfigSetters<T> annotatedService();

    @Override
    public AbstractContextPathServicesBuilder<T> decorator(Function<? super HttpService, ? extends HttpService> decorator) {
        return this.decorator(Route.ofCatchAll(), (Function)decorator);
    }

    @Override
    public AbstractContextPathServicesBuilder<T> decorator(DecoratingHttpServiceFunction decoratingHttpServiceFunction) {
        return this.decorator(Route.ofCatchAll(), decoratingHttpServiceFunction);
    }

    @Override
    public AbstractContextPathServicesBuilder<T> decorator(String pathPattern, Function<? super HttpService, ? extends HttpService> decorator) {
        return this.decorator(Route.builder().path(pathPattern).build(), (Function)decorator);
    }

    @Override
    public AbstractContextPathServicesBuilder<T> decorator(String pathPattern, DecoratingHttpServiceFunction decoratingHttpServiceFunction) {
        return this.decorator(Route.builder().path(pathPattern).build(), decoratingHttpServiceFunction);
    }

    @Override
    public AbstractContextPathServicesBuilder<T> decorator(Route route, Function<? super HttpService, ? extends HttpService> decorator) {
        Objects.requireNonNull(route, "route");
        Objects.requireNonNull(decorator, "decorator");
        for (String contextPath : this.contextPaths) {
            this.addRouteDecoratingService(new RouteDecoratingService(route, contextPath, decorator));
        }
        return this;
    }

    @Override
    public AbstractContextPathServicesBuilder<T> decorator(Route route, DecoratingHttpServiceFunction decoratingHttpServiceFunction) {
        Objects.requireNonNull(decoratingHttpServiceFunction, "decoratingHttpServiceFunction");
        return this.decorator(route, delegate -> new FunctionalDecoratingHttpService((HttpService)delegate, decoratingHttpServiceFunction));
    }

    @Override
    public AbstractContextPathServicesBuilder<T> decoratorUnder(String prefix, DecoratingHttpServiceFunction decoratingHttpServiceFunction) {
        return this.decorator(Route.builder().pathPrefix(prefix).build(), decoratingHttpServiceFunction);
    }

    @Override
    public AbstractContextPathServicesBuilder<T> decoratorUnder(String prefix, Function<? super HttpService, ? extends HttpService> decorator) {
        return this.decorator(Route.builder().pathPrefix(prefix).build(), (Function)decorator);
    }

    AbstractContextPathServicesBuilder<T> addServiceConfigSetters(ServiceConfigSetters serviceConfigSetters) {
        this.virtualHostBuilder.addServiceConfigSetters(serviceConfigSetters);
        return this;
    }

    AbstractContextPathServicesBuilder<T> addRouteDecoratingService(RouteDecoratingService routeDecoratingService) {
        this.virtualHostBuilder.addRouteDecoratingService(routeDecoratingService);
        return this;
    }

    public T and() {
        return this.parent;
    }

    final Set<String> contextPaths() {
        return this.contextPaths;
    }
}

