/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.util.function.Supplier;
import org.apache.calcite.linq4j.Nullness;

public class TryThreadLocal<T>
extends ThreadLocal<T> {
    private final T initialValue;

    public static <T> TryThreadLocal<T> of(T initialValue) {
        return new TryThreadLocal<T>(initialValue);
    }

    private TryThreadLocal(T initialValue) {
        this.initialValue = initialValue;
    }

    @Override
    protected final T initialValue() {
        return this.initialValue;
    }

    @Override
    public T get() {
        return (T)Nullness.castNonNull(super.get());
    }

    public Memo push(T value) {
        T previous = this.get();
        this.set(value);
        return () -> this.restoreTo(previous);
    }

    protected void restoreTo(T previous) {
        if (previous == this.initialValue) {
            this.remove();
        } else {
            this.set(previous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void letIn(T t, Runnable runnable) {
        T previous = this.get();
        if (previous == t) {
            runnable.run();
        } else {
            try {
                this.set(t);
                runnable.run();
            }
            finally {
                this.restoreTo(previous);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R letIn(T t, Supplier<R> supplier) {
        T previous = this.get();
        if (previous == t) {
            return supplier.get();
        }
        try {
            this.set(t);
            R r = supplier.get();
            return r;
        }
        finally {
            this.restoreTo(previous);
        }
    }

    public static interface Memo
    extends AutoCloseable {
        @Override
        public void close();
    }
}

