/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.DefaultHttpExecutionStrategy;
import io.servicetalk.http.api.DelegatingHttpConnectionContext;
import io.servicetalk.http.api.DelegatingHttpExecutionContext;
import io.servicetalk.http.api.HttpConnection;
import io.servicetalk.http.api.HttpConnectionContext;
import io.servicetalk.http.api.HttpEventKey;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpRequest;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpRequestResponseFactory;
import io.servicetalk.http.api.HttpResponse;
import io.servicetalk.http.api.HttpResponseFactory;
import io.servicetalk.http.api.RequestResponseFactories;
import io.servicetalk.http.api.StreamingHttpConnection;

final class StreamingHttpConnectionToHttpConnection
implements HttpConnection {
    static final HttpExecutionStrategy DEFAULT_ASYNC_CONNECTION_STRATEGY = DefaultHttpExecutionStrategy.OFFLOAD_RECEIVE_DATA_EVENT_STRATEGY;
    private final StreamingHttpConnection connection;
    private final HttpExecutionStrategy strategy;
    private final HttpConnectionContext context;
    private final HttpExecutionContext executionContext;
    private final HttpRequestResponseFactory reqRespFactory;

    StreamingHttpConnectionToHttpConnection(StreamingHttpConnection connection, HttpExecutionStrategy strategy) {
        this.strategy = HttpExecutionStrategies.defaultStrategy() == strategy ? DEFAULT_ASYNC_CONNECTION_STRATEGY : strategy;
        this.connection = connection;
        HttpConnectionContext originalCtx = connection.connectionContext();
        this.executionContext = new DelegatingHttpExecutionContext(connection.executionContext()){

            @Override
            public HttpExecutionStrategy executionStrategy() {
                return StreamingHttpConnectionToHttpConnection.this.strategy;
            }
        };
        this.context = new DelegatingHttpConnectionContext(originalCtx){

            @Override
            public HttpExecutionContext executionContext() {
                return StreamingHttpConnectionToHttpConnection.this.executionContext;
            }
        };
        this.reqRespFactory = RequestResponseFactories.toAggregated(connection);
    }

    @Override
    public HttpConnectionContext connectionContext() {
        return this.context;
    }

    @Override
    public <T> Publisher<? extends T> transportEventStream(HttpEventKey<T> eventKey) {
        return this.connection.transportEventStream(eventKey);
    }

    @Override
    public StreamingHttpConnection asStreamingConnection() {
        return this.connection;
    }

    @Override
    public Single<HttpResponse> request(HttpRequest request) {
        return this.connection.request(request.toStreamingRequest()).flatMap(response -> response.toResponse().shareContextOnSubscribe());
    }

    @Override
    public HttpExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public HttpResponseFactory httpResponseFactory() {
        return this.reqRespFactory;
    }

    @Override
    public void close() throws Exception {
        this.connection.close();
    }

    @Override
    public void closeGracefully() throws Exception {
        this.connection.closeGracefully();
    }

    public Completable onClose() {
        return this.connection.onClose();
    }

    public Completable closeAsync() {
        return this.connection.closeAsync();
    }

    public Completable closeAsyncGracefully() {
        return this.connection.closeAsyncGracefully();
    }

    @Override
    public HttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
        return this.reqRespFactory.newRequest(method, requestTarget);
    }
}

