/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.cli.iploc;

import io.servicetalk.http.api.BlockingStreamingHttpService;
import io.servicetalk.http.api.HttpServerContext;
import io.servicetalk.http.netty.HttpServers;
import io.servicetalk.http.router.jersey.HttpJerseyRouterBuilder;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import javax.ws.rs.core.Application;
import org.apache.baremaps.iploc.database.InetnumLocationDao;
import org.apache.baremaps.iploc.database.InetnumLocationDaoSqliteImpl;
import org.apache.baremaps.server.CorsFilter;
import org.apache.baremaps.server.IplocResources;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="serve", description={"Start an IP to location web service."})
public class Serve
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(Serve.class);
    @CommandLine.Option(names={"--database"}, paramLabel="DATABASE", description={"The path of the SQLite database."}, defaultValue="iploc.db")
    private Path database;
    @CommandLine.Option(names={"--host"}, paramLabel="HOST", description={"The host of the server."})
    private String host = "localhost";
    @CommandLine.Option(names={"--port"}, paramLabel="PORT", description={"The port of the server."})
    private int port = 9000;

    @Override
    public Integer call() throws Exception {
        String jdbcUrl = String.format("JDBC:sqlite:%s", this.database.toString());
        InetnumLocationDaoSqliteImpl inetnumLocationDao = new InetnumLocationDaoSqliteImpl(jdbcUrl);
        ResourceConfig application = new ResourceConfig().register(CorsFilter.class).register(IplocResources.class).register((Object)new AbstractBinder((InetnumLocationDao)inetnumLocationDao){
            final /* synthetic */ InetnumLocationDao val$inetnumLocationDao;
            {
                this.val$inetnumLocationDao = inetnumLocationDao;
            }

            protected void configure() {
                this.bind(this.val$inetnumLocationDao).to(InetnumLocationDao.class).named("inetnumLocationDao");
            }
        });
        BlockingStreamingHttpService httpService = new HttpJerseyRouterBuilder().buildBlockingStreaming((Application)application);
        HttpServerContext serverContext = HttpServers.forPort((int)this.port).listenBlockingStreamingAndAwait(httpService);
        logger.info("Listening on {}", (Object)serverContext.listenAddress());
        serverContext.awaitShutdown();
        return 0;
    }
}

