/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.GridVisorManagementTask;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.cache.VisorCacheLostPartitionsTaskArg;
import org.apache.ignite.internal.visor.cache.VisorCacheLostPartitionsTaskResult;

@GridInternal
@GridVisorManagementTask
public class VisorCacheLostPartitionsTask
extends VisorOneNodeTask<VisorCacheLostPartitionsTaskArg, VisorCacheLostPartitionsTaskResult> {
    private static final long serialVersionUID = 0L;

    protected VisorCacheLostPartitionsJob job(VisorCacheLostPartitionsTaskArg arg) {
        return new VisorCacheLostPartitionsJob(arg, this.debug);
    }

    private static class VisorCacheLostPartitionsJob
    extends VisorJob<VisorCacheLostPartitionsTaskArg, VisorCacheLostPartitionsTaskResult> {
        private static final long serialVersionUID = 0L;

        private VisorCacheLostPartitionsJob(VisorCacheLostPartitionsTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorCacheLostPartitionsTaskResult run(VisorCacheLostPartitionsTaskArg arg) {
            HashMap<String, List<Integer>> res = new HashMap<String, List<Integer>>();
            for (String cacheName : arg.getCacheNames()) {
                GridDhtPartitionTopology top;
                ArrayList<Integer> lostPartitions;
                IgniteInternalCache cache = this.ignite.cachex(cacheName);
                if (cache == null || (lostPartitions = new ArrayList<Integer>((top = cache.context().topology()).lostPartitions())).isEmpty()) continue;
                res.put(cacheName, lostPartitions);
            }
            return new VisorCacheLostPartitionsTaskResult(res);
        }

        public String toString() {
            return S.toString(VisorCacheLostPartitionsJob.class, this);
        }
    }
}

