/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.PartitionLossPolicy;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DiskPageCompression;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.cache.VisorCacheAffinityConfiguration;
import org.apache.ignite.internal.visor.cache.VisorCacheEvictionConfiguration;
import org.apache.ignite.internal.visor.cache.VisorCacheJdbcType;
import org.apache.ignite.internal.visor.cache.VisorCacheNearConfiguration;
import org.apache.ignite.internal.visor.cache.VisorCacheRebalanceConfiguration;
import org.apache.ignite.internal.visor.cache.VisorCacheStoreConfiguration;
import org.apache.ignite.internal.visor.query.VisorQueryConfiguration;
import org.apache.ignite.internal.visor.query.VisorQueryEntity;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class VisorCacheConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String name;
    private String grpName;
    private CacheMode mode;
    private CacheAtomicityMode atomicityMode;
    private boolean eagerTtl;
    private CacheWriteSynchronizationMode writeSynchronizationMode;
    private boolean invalidate;
    private int maxConcurrentAsyncOps;
    private String interceptor;
    private long dfltLockTimeout;
    private VisorCacheAffinityConfiguration affinityCfg;
    private VisorCacheRebalanceConfiguration rebalanceCfg;
    private VisorCacheEvictionConfiguration evictCfg;
    private VisorCacheNearConfiguration nearCfg;
    private VisorCacheStoreConfiguration storeCfg;
    private List<VisorQueryEntity> qryEntities;
    private List<VisorCacheJdbcType> jdbcTypes;
    private boolean statisticsEnabled;
    private boolean mgmtEnabled;
    private String ldrFactory;
    private String writerFactory;
    private String expiryPlcFactory;
    private VisorQueryConfiguration qryCfg;
    private boolean sys;
    private boolean storeKeepBinary;
    private boolean onheapCache;
    private PartitionLossPolicy partLossPlc;
    private int qryParallelism;
    private boolean cpOnRead;
    private String evictFilter;
    private String lsnrConfigurations;
    private boolean loadPrevVal;
    private String dataRegName;
    private int sqlIdxMaxInlineSize;
    private String nodeFilter;
    private int qryDetailMetricsSz;
    private boolean readFromBackup;
    private String tmLookupClsName;
    private String topValidator;
    private IgniteUuid dynamicDeploymentId;
    private DiskPageCompression diskPageCompression;
    private Integer diskPageCompressionLevel;

    public VisorCacheConfiguration() {
    }

    public VisorCacheConfiguration(IgniteEx ignite, CacheConfiguration ccfg, IgniteUuid dynamicDeploymentId) {
        this.name = ccfg.getName();
        this.grpName = ccfg.getGroupName();
        this.dynamicDeploymentId = dynamicDeploymentId;
        this.mode = ccfg.getCacheMode();
        this.atomicityMode = ccfg.getAtomicityMode();
        this.eagerTtl = ccfg.isEagerTtl();
        this.writeSynchronizationMode = ccfg.getWriteSynchronizationMode();
        this.invalidate = ccfg.isInvalidate();
        this.maxConcurrentAsyncOps = ccfg.getMaxConcurrentAsyncOperations();
        this.interceptor = VisorTaskUtils.compactClass(ccfg.getInterceptor());
        this.dfltLockTimeout = ccfg.getDefaultLockTimeout();
        this.qryEntities = VisorQueryEntity.list(ccfg.getQueryEntities());
        this.jdbcTypes = VisorCacheJdbcType.list(ccfg.getCacheStoreFactory());
        this.statisticsEnabled = ccfg.isStatisticsEnabled();
        this.mgmtEnabled = ccfg.isManagementEnabled();
        this.ldrFactory = VisorTaskUtils.compactClass(ccfg.getCacheLoaderFactory());
        this.writerFactory = VisorTaskUtils.compactClass(ccfg.getCacheWriterFactory());
        this.expiryPlcFactory = VisorTaskUtils.compactClass(ccfg.getExpiryPolicyFactory());
        this.sys = ignite.context().cache().systemCache(ccfg.getName());
        this.storeKeepBinary = ccfg.isStoreKeepBinary();
        this.onheapCache = ccfg.isOnheapCacheEnabled();
        this.partLossPlc = ccfg.getPartitionLossPolicy();
        this.qryParallelism = ccfg.getQueryParallelism();
        this.affinityCfg = new VisorCacheAffinityConfiguration(ccfg);
        this.rebalanceCfg = new VisorCacheRebalanceConfiguration(ccfg);
        this.evictCfg = new VisorCacheEvictionConfiguration(ccfg);
        this.nearCfg = new VisorCacheNearConfiguration(ccfg);
        this.storeCfg = new VisorCacheStoreConfiguration(ignite, ccfg);
        this.qryCfg = new VisorQueryConfiguration(ccfg);
        this.cpOnRead = ccfg.isCopyOnRead();
        this.evictFilter = VisorTaskUtils.compactClass(ccfg.getEvictionFilter());
        this.lsnrConfigurations = VisorTaskUtils.compactIterable(ccfg.getCacheEntryListenerConfigurations());
        this.loadPrevVal = ccfg.isLoadPreviousValue();
        this.dataRegName = ccfg.getDataRegionName();
        this.sqlIdxMaxInlineSize = ccfg.getSqlIndexMaxInlineSize();
        this.nodeFilter = VisorTaskUtils.compactClass(ccfg.getNodeFilter());
        this.qryDetailMetricsSz = ccfg.getQueryDetailMetricsSize();
        this.readFromBackup = ccfg.isReadFromBackup();
        this.tmLookupClsName = ccfg.getTransactionManagerLookupClassName();
        this.topValidator = VisorTaskUtils.compactClass(ccfg.getTopologyValidator());
        this.diskPageCompression = ccfg.getDiskPageCompression();
        this.diskPageCompressionLevel = ccfg.getDiskPageCompressionLevel();
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getGroupName() {
        return this.grpName;
    }

    public CacheMode getMode() {
        return this.mode;
    }

    public CacheAtomicityMode getAtomicityMode() {
        return this.atomicityMode;
    }

    public boolean eagerTtl() {
        return this.eagerTtl;
    }

    public CacheWriteSynchronizationMode getWriteSynchronizationMode() {
        return this.writeSynchronizationMode;
    }

    public boolean isInvalidate() {
        return this.invalidate;
    }

    public int getMaxConcurrentAsyncOperations() {
        return this.maxConcurrentAsyncOps;
    }

    @Nullable
    public String getInterceptor() {
        return this.interceptor;
    }

    public long getDefaultLockTimeout() {
        return this.dfltLockTimeout;
    }

    public List<VisorCacheJdbcType> getJdbcTypes() {
        return this.jdbcTypes;
    }

    public VisorCacheNearConfiguration getNearConfiguration() {
        return this.nearCfg;
    }

    public boolean isEagerTtl() {
        return this.eagerTtl;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public boolean isManagementEnabled() {
        return this.mgmtEnabled;
    }

    public String getLoaderFactory() {
        return this.ldrFactory;
    }

    public String getWriterFactory() {
        return this.writerFactory;
    }

    public String getExpiryPolicyFactory() {
        return this.expiryPlcFactory;
    }

    public VisorCacheAffinityConfiguration getAffinityConfiguration() {
        return this.affinityCfg;
    }

    public VisorCacheRebalanceConfiguration getRebalanceConfiguration() {
        return this.rebalanceCfg;
    }

    public VisorCacheEvictionConfiguration getEvictionConfiguration() {
        return this.evictCfg;
    }

    public VisorCacheStoreConfiguration getStoreConfiguration() {
        return this.storeCfg;
    }

    public List<VisorQueryEntity> getQueryEntities() {
        return this.qryEntities;
    }

    public VisorQueryConfiguration getQueryConfiguration() {
        return this.qryCfg;
    }

    public boolean isSystem() {
        return this.sys;
    }

    public Boolean isStoreKeepBinary() {
        return this.storeKeepBinary;
    }

    public boolean isOnheapCacheEnabled() {
        return this.onheapCache;
    }

    public PartitionLossPolicy getPartitionLossPolicy() {
        return this.partLossPlc;
    }

    public int getQueryParallelism() {
        return this.qryParallelism;
    }

    public boolean isCopyOnRead() {
        return this.cpOnRead;
    }

    public String getEvictionFilter() {
        return this.evictFilter;
    }

    public String getListenerConfigurations() {
        return this.lsnrConfigurations;
    }

    public boolean isLoadPreviousValue() {
        return this.loadPrevVal;
    }

    @Deprecated
    public String getMemoryPolicyName() {
        return this.dataRegName;
    }

    public int getSqlIndexMaxInlineSize() {
        return this.sqlIdxMaxInlineSize;
    }

    public String getNodeFilter() {
        return this.nodeFilter;
    }

    public int getQueryDetailMetricsSize() {
        return this.qryDetailMetricsSz;
    }

    public boolean isReadFromBackup() {
        return this.readFromBackup;
    }

    @Deprecated
    public String getTransactionManagerLookupClassName() {
        return this.tmLookupClsName;
    }

    public String getTopologyValidator() {
        return this.topValidator;
    }

    public IgniteUuid getDynamicDeploymentId() {
        return this.dynamicDeploymentId;
    }

    public DiskPageCompression getDiskPageCompression() {
        return this.diskPageCompression;
    }

    public Integer getDiskPageCompressionLevel() {
        return this.diskPageCompressionLevel;
    }

    @Override
    public byte getProtocolVersion() {
        return 2;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.name);
        U.writeString(out, this.grpName);
        U.writeEnum(out, this.mode);
        U.writeEnum(out, this.atomicityMode);
        out.writeBoolean(this.eagerTtl);
        U.writeEnum(out, this.writeSynchronizationMode);
        out.writeBoolean(this.invalidate);
        out.writeInt(this.maxConcurrentAsyncOps);
        U.writeString(out, this.interceptor);
        out.writeLong(this.dfltLockTimeout);
        out.writeObject(this.affinityCfg);
        out.writeObject(this.rebalanceCfg);
        out.writeObject(this.evictCfg);
        out.writeObject(this.nearCfg);
        out.writeObject(this.storeCfg);
        U.writeCollection(out, this.qryEntities);
        U.writeCollection(out, this.jdbcTypes);
        out.writeBoolean(this.statisticsEnabled);
        out.writeBoolean(this.mgmtEnabled);
        U.writeString(out, this.ldrFactory);
        U.writeString(out, this.writerFactory);
        U.writeString(out, this.expiryPlcFactory);
        out.writeObject(this.qryCfg);
        out.writeBoolean(this.sys);
        out.writeBoolean(this.storeKeepBinary);
        out.writeBoolean(this.onheapCache);
        U.writeEnum(out, this.partLossPlc);
        out.writeInt(this.qryParallelism);
        out.writeBoolean(this.cpOnRead);
        U.writeString(out, this.evictFilter);
        U.writeString(out, this.lsnrConfigurations);
        out.writeBoolean(this.loadPrevVal);
        U.writeString(out, this.dataRegName);
        out.writeInt(this.sqlIdxMaxInlineSize);
        U.writeString(out, this.nodeFilter);
        out.writeInt(this.qryDetailMetricsSz);
        out.writeBoolean(this.readFromBackup);
        U.writeString(out, this.tmLookupClsName);
        U.writeString(out, this.topValidator);
        U.writeIgniteUuid(out, this.dynamicDeploymentId);
        U.writeEnum(out, this.diskPageCompression);
        out.writeObject(this.diskPageCompressionLevel);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = U.readString(in);
        this.grpName = U.readString(in);
        this.mode = CacheMode.fromOrdinal(in.readByte());
        this.atomicityMode = CacheAtomicityMode.fromOrdinal(in.readByte());
        this.eagerTtl = in.readBoolean();
        this.writeSynchronizationMode = CacheWriteSynchronizationMode.fromOrdinal(in.readByte());
        this.invalidate = in.readBoolean();
        this.maxConcurrentAsyncOps = in.readInt();
        this.interceptor = U.readString(in);
        this.dfltLockTimeout = in.readLong();
        this.affinityCfg = (VisorCacheAffinityConfiguration)in.readObject();
        this.rebalanceCfg = (VisorCacheRebalanceConfiguration)in.readObject();
        this.evictCfg = (VisorCacheEvictionConfiguration)in.readObject();
        this.nearCfg = (VisorCacheNearConfiguration)in.readObject();
        this.storeCfg = (VisorCacheStoreConfiguration)in.readObject();
        this.qryEntities = U.readList(in);
        this.jdbcTypes = U.readList(in);
        this.statisticsEnabled = in.readBoolean();
        this.mgmtEnabled = in.readBoolean();
        this.ldrFactory = U.readString(in);
        this.writerFactory = U.readString(in);
        this.expiryPlcFactory = U.readString(in);
        this.qryCfg = (VisorQueryConfiguration)in.readObject();
        this.sys = in.readBoolean();
        this.storeKeepBinary = in.readBoolean();
        this.onheapCache = in.readBoolean();
        this.partLossPlc = PartitionLossPolicy.fromOrdinal(in.readByte());
        this.qryParallelism = in.readInt();
        this.cpOnRead = in.readBoolean();
        this.evictFilter = U.readString(in);
        this.lsnrConfigurations = U.readString(in);
        this.loadPrevVal = in.readBoolean();
        this.dataRegName = U.readString(in);
        this.sqlIdxMaxInlineSize = in.readInt();
        this.nodeFilter = U.readString(in);
        this.qryDetailMetricsSz = in.readInt();
        this.readFromBackup = in.readBoolean();
        this.tmLookupClsName = U.readString(in);
        this.topValidator = U.readString(in);
        this.dynamicDeploymentId = U.readIgniteUuid(in);
        if (protoVer > 1) {
            this.diskPageCompression = DiskPageCompression.fromOrdinal(in.readByte());
            this.diskPageCompressionLevel = (Integer)in.readObject();
        }
    }

    public String toString() {
        return S.toString(VisorCacheConfiguration.class, this);
    }
}

