/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cluster;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;

public class ClientClusterGroupGetNodesEndpointsResponse
extends ClientResponse {
    private static final long UNKNOWN_TOP_VER = -1L;
    private final long startTopVer;
    private final long endTopVer;

    public ClientClusterGroupGetNodesEndpointsResponse(long reqId, long startTopVer, long endTopVer) {
        super(reqId);
        this.startTopVer = startTopVer;
        this.endTopVer = endTopVer;
    }

    @Override
    public void encode(ClientConnectionContext ctx, BinaryRawWriterEx writer) {
        super.encode(ctx, writer);
        IgniteClusterEx cluster = ctx.kernalContext().grid().cluster();
        long endTopVer0 = this.endTopVer == -1L ? cluster.topologyVersion() : this.endTopVer;
        Collection<ClusterNode> topology = cluster.topology(endTopVer0);
        writer.writeLong(endTopVer0);
        if (this.startTopVer == -1L) {
            int pos = writer.reserveInt();
            int size = 0;
            for (ClusterNode node : topology) {
                if (!ClientClusterGroupGetNodesEndpointsResponse.writeNode(writer, node)) continue;
                ++size;
            }
            writer.writeInt(pos, size);
            writer.writeInt(0);
            return;
        }
        Map<UUID, ClusterNode> startNodes = ClientClusterGroupGetNodesEndpointsResponse.toMap(cluster.topology(this.startTopVer));
        Map<UUID, ClusterNode> endNodes = ClientClusterGroupGetNodesEndpointsResponse.toMap(topology);
        int pos = writer.reserveInt();
        int cnt = 0;
        for (Map.Entry<UUID, ClusterNode> endNode : endNodes.entrySet()) {
            if (startNodes.containsKey(endNode.getKey()) || !ClientClusterGroupGetNodesEndpointsResponse.writeNode(writer, endNode.getValue())) continue;
            ++cnt;
        }
        writer.writeInt(pos, cnt);
        pos = writer.reserveInt();
        cnt = 0;
        for (Map.Entry<UUID, ClusterNode> startNode : startNodes.entrySet()) {
            if (endNodes.containsKey(startNode.getKey()) || startNode.getValue().isClient()) continue;
            ClientClusterGroupGetNodesEndpointsResponse.writeUuid(writer, startNode.getKey());
            ++cnt;
        }
        writer.writeInt(pos, cnt);
    }

    private static boolean writeNode(BinaryRawWriterEx writer, ClusterNode node) {
        if (node.isClient()) {
            return false;
        }
        Object port = node.attribute("clientListenerPort");
        if (!(port instanceof Integer)) {
            return false;
        }
        ClientClusterGroupGetNodesEndpointsResponse.writeUuid(writer, node.id());
        writer.writeInt((Integer)port);
        Collection<String> addrs = node.addresses();
        Collection<String> hosts = node.hostNames();
        writer.writeInt(addrs.size() + hosts.size());
        for (String addr : addrs) {
            writer.writeString(addr);
        }
        for (String host : hosts) {
            writer.writeString(host);
        }
        return true;
    }

    private static void writeUuid(BinaryRawWriterEx writer, UUID id) {
        writer.writeLong(id.getMostSignificantBits());
        writer.writeLong(id.getLeastSignificantBits());
    }

    private static Map<UUID, ClusterNode> toMap(Collection<ClusterNode> nodes) {
        HashMap<UUID, ClusterNode> res = new HashMap<UUID, ClusterNode>(nodes.size());
        for (ClusterNode node : nodes) {
            res.put(node.id(), node);
        }
        return res;
    }
}

