/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.UUID;
import javax.cache.expiry.ExpiryPolicy;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class CacheOperationContext
implements Serializable {
    public static final boolean DFLT_ALLOW_ATOMIC_OPS_IN_TX = IgniteSystemProperties.getBoolean("IGNITE_ALLOW_ATOMIC_OPS_IN_TX", true);
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private final boolean skipStore;
    @GridToStringInclude
    private final boolean noRetries;
    private final boolean recovery;
    private final boolean readRepair;
    private final UUID subjId;
    private final boolean keepBinary;
    private final boolean allowAtomicOpsInTx;
    private final ExpiryPolicy expiryPlc;
    private final Byte dataCenterId;

    public CacheOperationContext() {
        this.skipStore = false;
        this.subjId = null;
        this.keepBinary = false;
        this.expiryPlc = null;
        this.noRetries = false;
        this.recovery = false;
        this.readRepair = false;
        this.dataCenterId = null;
        this.allowAtomicOpsInTx = DFLT_ALLOW_ATOMIC_OPS_IN_TX;
    }

    public CacheOperationContext(boolean skipStore, @Nullable UUID subjId, boolean keepBinary, @Nullable ExpiryPolicy expiryPlc, boolean noRetries, @Nullable Byte dataCenterId, boolean recovery, boolean readRepair, boolean allowAtomicOpsInTx) {
        this.skipStore = skipStore;
        this.subjId = subjId;
        this.keepBinary = keepBinary;
        this.expiryPlc = expiryPlc;
        this.noRetries = noRetries;
        this.dataCenterId = dataCenterId;
        this.recovery = recovery;
        this.readRepair = readRepair;
        this.allowAtomicOpsInTx = allowAtomicOpsInTx;
    }

    public boolean isKeepBinary() {
        return this.keepBinary;
    }

    public boolean hasDataCenterId() {
        return this.dataCenterId != null;
    }

    public CacheOperationContext keepBinary() {
        return new CacheOperationContext(this.skipStore, this.subjId, true, this.expiryPlc, this.noRetries, this.dataCenterId, this.recovery, this.readRepair, this.allowAtomicOpsInTx);
    }

    @Nullable
    public UUID subjectId() {
        return this.subjId;
    }

    @Nullable
    public Byte dataCenterId() {
        return this.dataCenterId;
    }

    public CacheOperationContext forSubjectId(UUID subjId) {
        return new CacheOperationContext(this.skipStore, subjId, this.keepBinary, this.expiryPlc, this.noRetries, this.dataCenterId, this.recovery, this.readRepair, this.allowAtomicOpsInTx);
    }

    public boolean skipStore() {
        return this.skipStore;
    }

    public CacheOperationContext setSkipStore(boolean skipStore) {
        return new CacheOperationContext(skipStore, this.subjId, this.keepBinary, this.expiryPlc, this.noRetries, this.dataCenterId, this.recovery, this.readRepair, this.allowAtomicOpsInTx);
    }

    @Nullable
    public ExpiryPolicy expiry() {
        return this.expiryPlc;
    }

    public CacheOperationContext withExpiryPolicy(ExpiryPolicy plc) {
        return new CacheOperationContext(this.skipStore, this.subjId, this.keepBinary, plc, this.noRetries, this.dataCenterId, this.recovery, this.readRepair, this.allowAtomicOpsInTx);
    }

    public CacheOperationContext setNoRetries(boolean noRetries) {
        return new CacheOperationContext(this.skipStore, this.subjId, this.keepBinary, this.expiryPlc, noRetries, this.dataCenterId, this.recovery, this.readRepair, this.allowAtomicOpsInTx);
    }

    public CacheOperationContext setDataCenterId(byte dataCenterId) {
        return new CacheOperationContext(this.skipStore, this.subjId, this.keepBinary, this.expiryPlc, this.noRetries, dataCenterId, this.recovery, this.readRepair, this.allowAtomicOpsInTx);
    }

    public CacheOperationContext setRecovery(boolean recovery) {
        return new CacheOperationContext(this.skipStore, this.subjId, this.keepBinary, this.expiryPlc, this.noRetries, this.dataCenterId, recovery, this.readRepair, this.allowAtomicOpsInTx);
    }

    public CacheOperationContext setReadRepair(boolean readRepair) {
        return new CacheOperationContext(this.skipStore, this.subjId, this.keepBinary, this.expiryPlc, this.noRetries, this.dataCenterId, this.recovery, readRepair, this.allowAtomicOpsInTx);
    }

    public boolean recovery() {
        return this.recovery;
    }

    public boolean readRepair() {
        return this.readRepair;
    }

    public boolean noRetries() {
        return this.noRetries;
    }

    public CacheOperationContext setAllowAtomicOpsInTx() {
        return new CacheOperationContext(this.skipStore, this.subjId, this.keepBinary, this.expiryPlc, this.noRetries, this.dataCenterId, this.recovery, this.readRepair, true);
    }

    public boolean allowedAtomicOpsInTx() {
        return this.allowAtomicOpsInTx;
    }

    public String toString() {
        return S.toString(CacheOperationContext.class, this);
    }
}

