/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

enum ClientOperation {
    RESOURCE_CLOSE(0),
    CACHE_GET_OR_CREATE_WITH_NAME(1052),
    CACHE_PUT(1001),
    CACHE_GET(1000),
    CACHE_CREATE_WITH_CONFIGURATION(1053),
    CACHE_GET_NAMES(1050),
    CACHE_DESTROY(1056),
    CACHE_GET_OR_CREATE_WITH_CONFIGURATION(1054),
    CACHE_CREATE_WITH_NAME(1051),
    CACHE_CONTAINS_KEY(1011),
    CACHE_GET_CONFIGURATION(1055),
    CACHE_GET_SIZE(1020),
    CACHE_PUT_ALL(1004),
    CACHE_GET_ALL(1003),
    CACHE_REPLACE_IF_EQUALS(1010),
    CACHE_REPLACE(1009),
    CACHE_REMOVE_KEY(1016),
    CACHE_REMOVE_IF_EQUALS(1017),
    CACHE_REMOVE_KEYS(1018),
    CACHE_REMOVE_ALL(1019),
    CACHE_GET_AND_PUT(1005),
    CACHE_GET_AND_REMOVE(1007),
    CACHE_GET_AND_REPLACE(1006),
    CACHE_PUT_IF_ABSENT(1002),
    CACHE_CLEAR(1013),
    CACHE_PARTITIONS(1101),
    QUERY_SCAN(2000),
    QUERY_SCAN_CURSOR_GET_PAGE(2001),
    QUERY_SQL(2002),
    QUERY_SQL_CURSOR_GET_PAGE(2003),
    QUERY_SQL_FIELDS(2004),
    QUERY_SQL_FIELDS_CURSOR_GET_PAGE(2005),
    GET_BINARY_TYPE(3002),
    REGISTER_BINARY_TYPE_NAME(3001),
    PUT_BINARY_TYPE(3003),
    GET_BINARY_TYPE_NAME(3000),
    TX_START(4000),
    TX_END(4001),
    CLUSTER_GET_STATE(5000),
    CLUSTER_CHANGE_STATE(5001),
    CLUSTER_GET_WAL_STATE(5003),
    CLUSTER_CHANGE_WAL_STATE(5002),
    CLUSTER_GROUP_GET_NODE_IDS(5100),
    CLUSTER_GROUP_GET_NODE_INFO(5101),
    COMPUTE_TASK_EXECUTE(6000),
    COMPUTE_TASK_FINISHED(6001, true),
    SERVICE_INVOKE(7000);

    private final int code;
    private final boolean notification;
    private static final Map<Short, ClientOperation> map;

    private ClientOperation(int code) {
        this(code, false);
    }

    private ClientOperation(int code, boolean notification) {
        this.code = code;
        this.notification = notification;
    }

    public short code() {
        return (short)this.code;
    }

    public boolean isNotification() {
        return this.notification;
    }

    @Nullable
    public static ClientOperation fromCode(short code) {
        return map.get(code);
    }

    static {
        map = new HashMap<Short, ClientOperation>();
        for (ClientOperation op : ClientOperation.values()) {
            map.put(op.code(), op);
        }
    }
}

