/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.internal.binary.BinaryObjectExImpl;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.streams.BinaryOutputStream;
import org.apache.ignite.internal.client.thin.ClientError;
import org.apache.ignite.internal.client.thin.ClientUtils;
import org.apache.ignite.internal.client.thin.PayloadInputChannel;
import org.apache.ignite.internal.client.thin.PayloadOutputChannel;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;

public class ClientCacheAffinityMapping {
    private static final CacheAffinityInfo NOT_APPLICABLE_CACHE_AFFINITY_INFO = new CacheAffinityInfo(null, null);
    private final AffinityTopologyVersion topVer;
    private final Map<Integer, CacheAffinityInfo> cacheAffinity = new HashMap<Integer, CacheAffinityInfo>();
    private final Collection<Integer> cacheIds = Collections.unmodifiableCollection(this.cacheAffinity.keySet());

    private ClientCacheAffinityMapping(AffinityTopologyVersion topVer) {
        this.topVer = topVer;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public Collection<Integer> cacheIds() {
        return this.cacheIds;
    }

    public UUID affinityNode(IgniteBinary binary, int cacheId, Object key) {
        CacheAffinityInfo affinityInfo = this.cacheAffinity.get(cacheId);
        if (affinityInfo == null || affinityInfo == NOT_APPLICABLE_CACHE_AFFINITY_INFO) {
            return null;
        }
        Object binaryKey = binary.toBinary(key);
        if (!affinityInfo.keyCfg.isEmpty()) {
            int typeId = binary.typeId(key.getClass().getName());
            Integer fieldId = (Integer)affinityInfo.keyCfg.get(typeId);
            if (fieldId != null) {
                if (binaryKey instanceof BinaryObjectExImpl) {
                    binaryKey = ((BinaryObjectExImpl)binaryKey).field(fieldId);
                } else {
                    return null;
                }
            }
        }
        return affinityInfo.nodeForKey(binaryKey);
    }

    public static ClientCacheAffinityMapping merge(ClientCacheAffinityMapping ... mappings) {
        assert (!F.isEmpty(mappings));
        ClientCacheAffinityMapping res = new ClientCacheAffinityMapping(mappings[0].topVer);
        for (ClientCacheAffinityMapping mapping : mappings) {
            assert (res.topVer.equals(mapping.topVer)) : "Mappings must have identical topology versions [res.topVer=" + res.topVer + ", mapping.topVer=" + mapping.topVer + ']';
            for (Map.Entry<Integer, CacheAffinityInfo> entry : mapping.cacheAffinity.entrySet()) {
                res.cacheAffinity.put(entry.getKey(), entry.getValue());
            }
        }
        return res;
    }

    public static void writeRequest(PayloadOutputChannel ch, Collection<Integer> cacheIds) {
        BinaryOutputStream out = ch.out();
        out.writeInt(cacheIds.size());
        for (int cacheId : cacheIds) {
            out.writeInt(cacheId);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClientCacheAffinityMapping readResponse(PayloadInputChannel ch) {
        try (BinaryReaderExImpl in = ClientUtils.createBinaryReader(null, ch.in());){
            long topVer = in.readLong();
            int minorTopVer = in.readInt();
            ClientCacheAffinityMapping aff = new ClientCacheAffinityMapping(new AffinityTopologyVersion(topVer, minorTopVer));
            int mappingsCnt = in.readInt();
            for (int i = 0; i < mappingsCnt; ++i) {
                boolean applicable = in.readBoolean();
                int cachesCnt = in.readInt();
                if (applicable) {
                    HashMap<Integer, Map<Integer, Integer>> cacheKeyCfg = U.newHashMap(cachesCnt);
                    for (int j = 0; j < cachesCnt; ++j) {
                        cacheKeyCfg.put(in.readInt(), ClientCacheAffinityMapping.readCacheKeyConfiguration(in));
                    }
                    UUID[] partToNode = ClientCacheAffinityMapping.readNodePartitions(in);
                    for (Map.Entry keyCfg : cacheKeyCfg.entrySet()) {
                        aff.cacheAffinity.put((Integer)keyCfg.getKey(), new CacheAffinityInfo((Map)keyCfg.getValue(), partToNode));
                    }
                    continue;
                }
                for (int j = 0; j < cachesCnt; ++j) {
                    aff.cacheAffinity.put(in.readInt(), NOT_APPLICABLE_CACHE_AFFINITY_INFO);
                }
            }
            ClientCacheAffinityMapping clientCacheAffinityMapping = aff;
            return clientCacheAffinityMapping;
        }
        catch (IOException e) {
            throw new ClientError(e);
        }
    }

    private static Map<Integer, Integer> readCacheKeyConfiguration(BinaryReaderExImpl in) {
        int keyCfgCnt = in.readInt();
        HashMap<Integer, Integer> keyCfg = U.newHashMap(keyCfgCnt);
        for (int i = 0; i < keyCfgCnt; ++i) {
            keyCfg.put(in.readInt(), in.readInt());
        }
        return keyCfg;
    }

    private static UUID[] readNodePartitions(BinaryReaderExImpl in) {
        int nodesCnt = in.readInt();
        int maxPart = -1;
        UUID[] partToNode = new UUID[1024];
        for (int i = 0; i < nodesCnt; ++i) {
            UUID nodeId = in.readUuid();
            int partCnt = in.readInt();
            for (int j = 0; j < partCnt; ++j) {
                int part = in.readInt();
                if (part > maxPart) {
                    maxPart = part;
                    if (part >= partToNode.length) {
                        partToNode = Arrays.copyOf(partToNode, U.ceilPow2(part + 1));
                    }
                }
                partToNode[part] = nodeId;
            }
        }
        return Arrays.copyOf(partToNode, maxPart + 1);
    }

    private static class CacheAffinityInfo {
        private final Map<Integer, Integer> keyCfg;
        private final UUID[] partMapping;
        private final int affinityMask;

        private CacheAffinityInfo(Map<Integer, Integer> keyCfg, UUID[] partMapping) {
            this.keyCfg = keyCfg;
            this.partMapping = partMapping;
            this.affinityMask = partMapping != null ? RendezvousAffinityFunction.calculateMask(partMapping.length) : 0;
        }

        private UUID nodeForKey(Object key) {
            assert (this.partMapping != null);
            int part = RendezvousAffinityFunction.calculatePartition(key, this.affinityMask, this.partMapping.length);
            return this.partMapping[part];
        }
    }
}

