/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.util.BitSet;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.managers.discovery.IgniteDiscoverySpi;
import org.apache.ignite.spi.discovery.DiscoverySpi;

public final class IgniteFeatures
extends Enum<IgniteFeatures> {
    public static final /* enum */ IgniteFeatures TCP_COMMUNICATION_SPI_HANDSHAKE_WAIT_MESSAGE = new IgniteFeatures(0);
    public static final /* enum */ IgniteFeatures CACHE_METRICS_V2 = new IgniteFeatures(1);
    public static final /* enum */ IgniteFeatures DATA_PACKET_COMPRESSION = new IgniteFeatures(3);
    public static final /* enum */ IgniteFeatures DIFFERENT_REBALANCE_POOL_SIZE = new IgniteFeatures(4);
    public static final /* enum */ IgniteFeatures SPLITTED_CACHE_CONFIGURATIONS = new IgniteFeatures(5);
    public static final /* enum */ IgniteFeatures TRANSACTION_OWNER_THREAD_DUMP_PROVIDING = new IgniteFeatures(6);
    public static final /* enum */ IgniteFeatures TX_INFO_COMMAND = new IgniteFeatures(7);
    public static final /* enum */ IgniteFeatures FIND_AND_DELETE_GARBAGE_COMMAND = new IgniteFeatures(8);
    public static final /* enum */ IgniteFeatures CLUSTER_READ_ONLY_MODE = new IgniteFeatures(9);
    public static final /* enum */ IgniteFeatures SUSPEND_RESUME_PESSIMISTIC_TX = new IgniteFeatures(10);
    public static final /* enum */ IgniteFeatures DISTRIBUTED_METASTORAGE = new IgniteFeatures(11);
    public static final /* enum */ IgniteFeatures CHANNEL_COMMUNICATION = new IgniteFeatures(12);
    public static final /* enum */ IgniteFeatures TCP_DISCOVERY_MESSAGE_NODE_COMPACT_REPRESENTATION = new IgniteFeatures(14);
    public static final /* enum */ IgniteFeatures LRT_SYSTEM_USER_TIME_DUMP_SETTINGS = new IgniteFeatures(18);
    public static final /* enum */ IgniteFeatures PME_FREE_SWITCH = new IgniteFeatures(19);
    public static final /* enum */ IgniteFeatures MASTER_KEY_CHANGE = new IgniteFeatures(20);
    public static final /* enum */ IgniteFeatures CONT_QRY_SECURITY_AWARE = new IgniteFeatures(21);
    public static final /* enum */ IgniteFeatures SAFE_CLUSTER_DEACTIVATION = new IgniteFeatures(22);
    public static final /* enum */ IgniteFeatures PERSISTENCE_CACHE_SNAPSHOT = new IgniteFeatures(23);
    public static final /* enum */ IgniteFeatures TRACING = new IgniteFeatures(26);
    public static final /* enum */ IgniteFeatures DISTRIBUTED_CHANGE_LONG_OPERATIONS_DUMP_TIMEOUT = new IgniteFeatures(30);
    public static final /* enum */ IgniteFeatures VOLATILE_DATA_STRUCTURES_REGION = new IgniteFeatures(33);
    public static final /* enum */ IgniteFeatures CHECK_INDEX_INLINE_SIZES = new IgniteFeatures(36);
    public static final /* enum */ IgniteFeatures DISTRIBUTED_TX_COLLISIONS_DUMP = new IgniteFeatures(37);
    public static final /* enum */ IgniteFeatures REMOVE_METADATA = new IgniteFeatures(39);
    public static final /* enum */ IgniteFeatures SHUTDOWN_POLICY = new IgniteFeatures(40);
    public static final /* enum */ IgniteFeatures INDEXES_MANIPULATIONS_FROM_CONTROL_SCRIPT = new IgniteFeatures(42);
    public static final /* enum */ IgniteFeatures MVCC_TX_RECOVERY_PROTOCOL_V2 = new IgniteFeatures(44);
    public static final /* enum */ IgniteFeatures SPECIFIED_SEQ_PK_KEYS = new IgniteFeatures(45);
    public static final /* enum */ IgniteFeatures SPLITTED_CACHE_CONFIGURATIONS_V2 = new IgniteFeatures(46);
    public static final /* enum */ IgniteFeatures CACHE_GROUP_KEY_CHANGE = new IgniteFeatures(47);
    public static final /* enum */ IgniteFeatures PERFORMANCE_STATISTICS = new IgniteFeatures(48);
    private final int featureId;
    private static final /* synthetic */ IgniteFeatures[] $VALUES;

    public static IgniteFeatures[] values() {
        return (IgniteFeatures[])$VALUES.clone();
    }

    public static IgniteFeatures valueOf(String name) {
        return Enum.valueOf(IgniteFeatures.class, name);
    }

    private IgniteFeatures(int featureId) {
        this.featureId = featureId;
    }

    public int getFeatureId() {
        return this.featureId;
    }

    public static boolean nodeSupports(ClusterNode clusterNode, IgniteFeatures feature) {
        byte[] features = (byte[])clusterNode.attribute("org.apache.ignite.features");
        if (features == null) {
            return false;
        }
        return IgniteFeatures.nodeSupports(features, feature);
    }

    public static boolean nodeSupports(byte[] featuresAttrBytes, IgniteFeatures feature) {
        int featureId = feature.getFeatureId();
        int byteIdx = featureId >>> 3;
        if (byteIdx >= featuresAttrBytes.length) {
            return false;
        }
        int bitIdx = featureId & 7;
        return (featuresAttrBytes[byteIdx] & 1 << bitIdx) != 0;
    }

    public static boolean allNodesSupports(Iterable<ClusterNode> nodes, IgniteFeatures feature) {
        for (ClusterNode next : nodes) {
            if (IgniteFeatures.nodeSupports(next, feature)) continue;
            return false;
        }
        return true;
    }

    public static boolean allNodesSupport(DiscoverySpi discoSpi, IgniteFeatures feature) {
        if (discoSpi instanceof IgniteDiscoverySpi) {
            return ((IgniteDiscoverySpi)discoSpi).allNodesSupport(feature);
        }
        return IgniteFeatures.allNodesSupports(discoSpi.getRemoteNodes(), feature);
    }

    public static byte[] allFeatures() {
        BitSet set = new BitSet();
        for (IgniteFeatures value : IgniteFeatures.values()) {
            if (value == PME_FREE_SWITCH && IgniteSystemProperties.getBoolean("IGNITE_PME_FREE_SWITCH_DISABLED")) continue;
            int featureId = value.getFeatureId();
            assert (!set.get(featureId)) : "Duplicate feature ID found for [" + (Object)((Object)value) + "] having same ID [" + featureId + "]";
            set.set(featureId);
        }
        return set.toByteArray();
    }

    static {
        $VALUES = new IgniteFeatures[]{TCP_COMMUNICATION_SPI_HANDSHAKE_WAIT_MESSAGE, CACHE_METRICS_V2, DATA_PACKET_COMPRESSION, DIFFERENT_REBALANCE_POOL_SIZE, SPLITTED_CACHE_CONFIGURATIONS, TRANSACTION_OWNER_THREAD_DUMP_PROVIDING, TX_INFO_COMMAND, FIND_AND_DELETE_GARBAGE_COMMAND, CLUSTER_READ_ONLY_MODE, SUSPEND_RESUME_PESSIMISTIC_TX, DISTRIBUTED_METASTORAGE, CHANNEL_COMMUNICATION, TCP_DISCOVERY_MESSAGE_NODE_COMPACT_REPRESENTATION, LRT_SYSTEM_USER_TIME_DUMP_SETTINGS, PME_FREE_SWITCH, MASTER_KEY_CHANGE, CONT_QRY_SECURITY_AWARE, SAFE_CLUSTER_DEACTIVATION, PERSISTENCE_CACHE_SNAPSHOT, TRACING, DISTRIBUTED_CHANGE_LONG_OPERATIONS_DUMP_TIMEOUT, VOLATILE_DATA_STRUCTURES_REGION, CHECK_INDEX_INLINE_SIZES, DISTRIBUTED_TX_COLLISIONS_DUMP, REMOVE_METADATA, SHUTDOWN_POLICY, INDEXES_MANIPULATIONS_FROM_CONTROL_SCRIPT, MVCC_TX_RECOVERY_PROTOCOL_V2, SPECIFIED_SEQ_PK_KEYS, SPLITTED_CACHE_CONFIGURATIONS_V2, CACHE_GROUP_KEY_CHANGE, PERFORMANCE_STATISTICS};
    }
}

