/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class CacheConfigurationCollectorTaskArg
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private Collection<String> cacheNames;
    private String regex;

    public CacheConfigurationCollectorTaskArg() {
    }

    public CacheConfigurationCollectorTaskArg(Collection<String> cacheNames) {
        this.cacheNames = cacheNames;
    }

    public CacheConfigurationCollectorTaskArg(String regex) {
        Pattern.compile(regex);
        this.regex = regex;
    }

    public Collection<String> getCacheNames() {
        return this.cacheNames;
    }

    public String getRegex() {
        return this.regex;
    }

    @Override
    public byte getProtocolVersion() {
        return 2;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeCollection(out, this.cacheNames);
        U.writeString(out, this.regex);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.cacheNames = U.readCollection(in);
        if (protoVer > 1) {
            this.regex = U.readString(in);
        }
    }

    public String toString() {
        return S.toString(CacheConfigurationCollectorTaskArg.class, this);
    }
}

