/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.expression;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import java.util.List;
import java.util.Objects;

class InstanceOfBytecodeExpression
extends BytecodeExpression {
    private final BytecodeExpression instance;
    private final Class<?> type;

    InstanceOfBytecodeExpression(BytecodeExpression instance, Class<?> type) {
        super(ParameterizedType.type(Boolean.TYPE));
        this.instance = Objects.requireNonNull(instance, "instance is null");
        this.type = Objects.requireNonNull(type, "type is null");
    }

    public static BytecodeExpression instanceOf(BytecodeExpression instance, Class<?> type) {
        return new InstanceOfBytecodeExpression(instance, type);
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        return new BytecodeBlock().append(this.instance).isInstanceOf(this.type);
    }

    @Override
    protected String formatOneLine() {
        return String.valueOf(this.instance) + " instanceof " + String.valueOf(this.type);
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return List.of();
    }
}

