/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.mv.gc;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.pagememory.PageMemory;
import org.apache.ignite.internal.pagememory.reuse.ReuseList;
import org.apache.ignite.internal.pagememory.tree.BplusTree;
import org.apache.ignite.internal.pagememory.tree.io.BplusIo;
import org.apache.ignite.internal.pagememory.util.PageLockListener;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.pagememory.mv.gc.GcRowVersion;
import org.apache.ignite.internal.storage.pagememory.mv.gc.io.GcInnerIo;
import org.apache.ignite.internal.storage.pagememory.mv.gc.io.GcIo;
import org.apache.ignite.internal.storage.pagememory.mv.gc.io.GcLeafIo;
import org.apache.ignite.internal.storage.pagememory.mv.gc.io.GcMetaIo;
import org.jetbrains.annotations.Nullable;

public class GcQueue
extends BplusTree<GcRowVersion, GcRowVersion> {
    public GcQueue(int grpId, String grpName, int partId, PageMemory pageMem, PageLockListener lockLsnr, AtomicLong globalRmvId, long metaPageId, @Nullable ReuseList reuseList, boolean initNew) throws IgniteInternalCheckedException {
        super("GarbageCollectionTree", grpId, grpName, partId, pageMem, lockLsnr, globalRmvId, metaPageId, reuseList);
        this.setIos(GcInnerIo.VERSIONS, GcLeafIo.VERSIONS, GcMetaIo.VERSIONS);
        this.initTree(initNew);
    }

    protected int compare(BplusIo<GcRowVersion> io, long pageAddr, int idx, GcRowVersion row) {
        GcIo gcIo = (GcIo)io;
        return gcIo.compare(pageAddr, idx, row);
    }

    public GcRowVersion getRow(BplusIo<GcRowVersion> io, long pageAddr, int idx, Object x) {
        GcIo gcIo = (GcIo)io;
        return gcIo.getRow(pageAddr, idx, this.partId);
    }

    public void add(RowId rowId, HybridTimestamp timestamp, long link) {
        try {
            this.put(new GcRowVersion(rowId, timestamp, link));
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error occurred while adding row version to the garbage collection queue: [rowId={}, timestamp={}, {}]", (Throwable)e, new Object[]{rowId, timestamp});
        }
    }

    public boolean remove(RowId rowId, HybridTimestamp timestamp, long link) {
        try {
            return this.removex(new GcRowVersion(rowId, timestamp, link));
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error occurred while deleting row version form the garbage collection queue: [rowId={}, timestamp={}, {}]", (Throwable)e, new Object[]{rowId, timestamp});
        }
    }

    @Nullable
    public GcRowVersion getFirst() {
        try {
            return (GcRowVersion)this.findFirst();
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error occurred while getting the first element from the garbage collection queue", (Throwable)e);
        }
    }
}

