/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.rocksdb;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.internal.rocksdb.ColumnFamily;
import org.apache.ignite.internal.storage.index.HashIndexStorage;
import org.apache.ignite.internal.storage.index.IndexStorage;
import org.apache.ignite.internal.storage.index.SortedIndexStorage;
import org.apache.ignite.internal.storage.index.StorageHashIndexDescriptor;
import org.apache.ignite.internal.storage.index.StorageIndexDescriptorSupplier;
import org.apache.ignite.internal.storage.index.StorageSortedIndexDescriptor;
import org.apache.ignite.internal.storage.rocksdb.HashIndex;
import org.apache.ignite.internal.storage.rocksdb.Index;
import org.apache.ignite.internal.storage.rocksdb.RocksDbStorageUtils;
import org.apache.ignite.internal.storage.rocksdb.SortedIndex;
import org.apache.ignite.internal.storage.rocksdb.index.AbstractRocksDbIndexStorage;
import org.apache.ignite.internal.storage.rocksdb.index.RocksDbHashIndexStorage;
import org.apache.ignite.internal.storage.rocksdb.index.RocksDbSortedIndexStorage;
import org.apache.ignite.internal.storage.rocksdb.instance.IndexColumnFamily;
import org.apache.ignite.internal.storage.rocksdb.instance.SharedRocksDbInstance;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteBatch;

class RocksDbIndexes {
    private final ConcurrentMap<Integer, HashIndex> hashIndices = new ConcurrentHashMap<Integer, HashIndex>();
    private final ConcurrentMap<Integer, SortedIndex> sortedIndices = new ConcurrentHashMap<Integer, SortedIndex>();
    private final SharedRocksDbInstance rocksDb;
    private final int tableId;

    RocksDbIndexes(SharedRocksDbInstance rocksDb, int tableId) {
        this.rocksDb = rocksDb;
        this.tableId = tableId;
    }

    void recoverIndexes(StorageIndexDescriptorSupplier indexDescriptorSupplier) throws RocksDBException {
        try (WriteBatch writeBatch = new WriteBatch();){
            for (int indexId : this.rocksDb.hashIndexIds(this.tableId)) {
                StorageHashIndexDescriptor descriptor = (StorageHashIndexDescriptor)indexDescriptorSupplier.get(indexId);
                if (descriptor == null) {
                    SharedRocksDbInstance.deleteByPrefix(writeBatch, this.rocksDb.hashIndexCf(), RocksDbIndexes.indexPrefix(this.tableId, indexId));
                    continue;
                }
                this.hashIndices.put(indexId, new HashIndex(this.tableId, this.rocksDb.hashIndexCf(), descriptor, this.rocksDb.meta));
            }
            ArrayList<ColumnFamily> indexCfsToDestroy = new ArrayList<ColumnFamily>();
            for (IndexColumnFamily indexColumnFamily : this.rocksDb.sortedIndexes(this.tableId)) {
                int indexId = indexColumnFamily.indexId();
                ColumnFamily cf = indexColumnFamily.columnFamily();
                StorageSortedIndexDescriptor descriptor = (StorageSortedIndexDescriptor)indexDescriptorSupplier.get(indexId);
                if (descriptor == null) {
                    this.rocksDb.removeSortedIndex(indexId, cf);
                    SharedRocksDbInstance.deleteByPrefix(writeBatch, cf, RocksDbIndexes.indexPrefix(this.tableId, indexId));
                    indexCfsToDestroy.add(cf);
                    continue;
                }
                this.sortedIndices.put(indexId, SortedIndex.restoreExisting(this.tableId, cf, descriptor, this.rocksDb.meta));
            }
            this.rocksDb.db.write(SharedRocksDbInstance.DFLT_WRITE_OPTS, writeBatch);
            if (!indexCfsToDestroy.isEmpty()) {
                this.rocksDb.scheduleIndexCfsDestroyIfNeeded(indexCfsToDestroy);
            }
        }
    }

    SortedIndexStorage getOrCreateSortedIndex(int partitionId, StorageSortedIndexDescriptor indexDescriptor) {
        SortedIndex sortedIndex = this.sortedIndices.computeIfAbsent(indexDescriptor.id(), id -> SortedIndex.createNew(this.rocksDb, this.tableId, indexDescriptor, this.rocksDb.meta));
        return (SortedIndexStorage)sortedIndex.getOrCreateStorage(partitionId);
    }

    HashIndexStorage getOrCreateHashIndex(int partitionId, StorageHashIndexDescriptor indexDescriptor) {
        HashIndex hashIndex = this.hashIndices.computeIfAbsent(indexDescriptor.id(), id -> new HashIndex(this.tableId, this.rocksDb.hashIndexCf(), indexDescriptor, this.rocksDb.meta));
        return (HashIndexStorage)hashIndex.getOrCreateStorage(partitionId);
    }

    @Nullable
    IndexStorage getIndex(int partitionId, int indexId) {
        HashIndex hashIndex = (HashIndex)this.hashIndices.get(indexId);
        if (hashIndex != null) {
            assert (!this.sortedIndices.containsKey(indexId)) : indexId;
            return hashIndex.getOrCreateStorage(partitionId);
        }
        SortedIndex sortedIndex = (SortedIndex)this.sortedIndices.get(indexId);
        if (sortedIndex != null) {
            return sortedIndex.getOrCreateStorage(partitionId);
        }
        return null;
    }

    void startRebalance(int partitionId, WriteBatch writeBatch) {
        this.getAllStorages(partitionId).forEach(indexStorage -> indexStorage.startRebalance(writeBatch));
    }

    void abortRebalance(int partitionId, WriteBatch writeBatch) {
        this.getAllStorages(partitionId).forEach(indexStorage -> indexStorage.abortRebalance(writeBatch));
    }

    void finishRebalance(int partitionId) {
        this.getAllStorages(partitionId).forEach(AbstractRocksDbIndexStorage::finishRebalance);
    }

    List<AutoCloseable> getResourcesForClose() {
        return this.allIndexes().map(index -> index::close).collect(Collectors.toList());
    }

    List<AutoCloseable> getResourcesForDestroy() {
        return this.allIndexes().map(index -> index::transitionToDestroyedState).collect(Collectors.toList());
    }

    private Stream<Index<?>> allIndexes() {
        return Stream.concat(this.hashIndices.values().stream(), this.sortedIndices.values().stream());
    }

    void destroyIndex(int indexId) throws RocksDBException {
        HashIndex hashIdx = (HashIndex)this.hashIndices.remove(indexId);
        SortedIndex sortedIdx = (SortedIndex)this.sortedIndices.remove(indexId);
        if (hashIdx == null && sortedIdx == null) {
            return;
        }
        try (WriteBatch writeBatch = new WriteBatch();){
            if (hashIdx != null) {
                hashIdx.destroy(writeBatch);
            }
            if (sortedIdx != null) {
                this.rocksDb.removeSortedIndex(indexId, sortedIdx.columnFamily());
                sortedIdx.destroy(writeBatch);
            }
            this.rocksDb.db.write(SharedRocksDbInstance.DFLT_WRITE_OPTS, writeBatch);
        }
        if (sortedIdx != null) {
            this.rocksDb.scheduleIndexCfsDestroyIfNeeded(List.of(sortedIdx.columnFamily()));
        }
    }

    void destroyAllIndexesForPartition(int partitionId, WriteBatch writeBatch) throws RocksDBException {
        for (HashIndex hashIndex : this.hashIndices.values()) {
            hashIndex.destroy(partitionId, writeBatch);
        }
        for (SortedIndex sortedIndex : this.sortedIndices.values()) {
            sortedIndex.destroy(partitionId, writeBatch);
        }
    }

    Stream<AbstractRocksDbIndexStorage> getAllStorages(int partitionId) {
        return Stream.concat(this.hashIndices.values().stream().map(index -> (RocksDbHashIndexStorage)index.getStorage(partitionId)), this.sortedIndices.values().stream().map(index -> (RocksDbSortedIndexStorage)index.getStorage(partitionId)));
    }

    static byte[] indexPrefix(int tableId, int indexId) {
        return ByteBuffer.allocate(8).order(RocksDbStorageUtils.KEY_BYTE_ORDER).putInt(tableId).putInt(indexId).array();
    }
}

