/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.raft;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.raft.RaftGroupConfiguration;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.PartitionTimestampCursor;
import org.apache.ignite.internal.storage.ReadResult;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.TxIdMismatchException;
import org.apache.ignite.internal.storage.gc.GcEntry;
import org.apache.ignite.internal.util.Cursor;
import org.jetbrains.annotations.Nullable;

public interface PartitionDataStorage
extends ManuallyCloseable {
    public int tableId();

    public int partitionId();

    public <V> V runConsistently(MvPartitionStorage.WriteClosure<V> var1) throws StorageException;

    public void acquirePartitionSnapshotsReadLock();

    public void releasePartitionSnapshotsReadLock();

    default public CompletableFuture<Void> flush() {
        return this.flush(true);
    }

    public CompletableFuture<Void> flush(boolean var1);

    public long lastAppliedIndex();

    public long lastAppliedTerm();

    public void lastApplied(long var1, long var3) throws StorageException;

    public void committedGroupConfiguration(RaftGroupConfiguration var1);

    @Nullable
    public BinaryRow addWrite(RowId var1, @Nullable BinaryRow var2, UUID var3, int var4, int var5) throws TxIdMismatchException, StorageException;

    public void addWriteCommitted(RowId var1, @Nullable BinaryRow var2, HybridTimestamp var3);

    @Nullable
    public BinaryRow abortWrite(RowId var1) throws StorageException;

    public void commitWrite(RowId var1, HybridTimestamp var2) throws StorageException;

    public Cursor<ReadResult> scanVersions(RowId var1) throws StorageException;

    public MvPartitionStorage getStorage();

    public void close();

    public PartitionTimestampCursor scan(HybridTimestamp var1) throws StorageException;

    @Nullable
    public GcEntry peek(HybridTimestamp var1);

    @Nullable
    public BinaryRow vacuum(GcEntry var1);

    public void updateLease(long var1, UUID var3, String var4);

    public long leaseStartTime();

    public UUID primaryReplicaNodeId();

    public String primaryReplicaNodeName();
}

