/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.configuration;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.type.DecimalNativeType;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.util.StringUtils;

public final class ValueSerializationHelper {
    public static String toString(Object defaultValue, NativeType type) {
        Objects.requireNonNull(defaultValue, "defaultValue");
        Objects.requireNonNull(type, "type");
        switch (type.spec()) {
            case BOOLEAN: 
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: 
            case DATE: 
            case TIME: 
            case DATETIME: 
            case TIMESTAMP: 
            case STRING: 
            case UUID: {
                return defaultValue.toString();
            }
            case BYTES: {
                return StringUtils.toHexString((byte[])((byte[])defaultValue));
            }
        }
        throw new IllegalStateException("Unknown type [type=" + String.valueOf(type) + "]");
    }

    public static Object fromString(String defaultValue, NativeType type) {
        Objects.requireNonNull(defaultValue, "defaultValue");
        Objects.requireNonNull(type, "type");
        switch (type.spec()) {
            case BOOLEAN: {
                return Boolean.parseBoolean(defaultValue);
            }
            case INT8: {
                return Byte.parseByte(defaultValue);
            }
            case INT16: {
                return Short.parseShort(defaultValue);
            }
            case INT32: {
                return Integer.parseInt(defaultValue);
            }
            case INT64: {
                return Long.parseLong(defaultValue);
            }
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(defaultValue));
            }
            case DOUBLE: {
                return Double.parseDouble(defaultValue);
            }
            case DECIMAL: {
                assert (type instanceof DecimalNativeType);
                return new BigDecimal(defaultValue).setScale(((DecimalNativeType)type).scale(), RoundingMode.HALF_UP);
            }
            case DATE: {
                return LocalDate.parse(defaultValue);
            }
            case TIME: {
                return LocalTime.parse(defaultValue);
            }
            case DATETIME: {
                return LocalDateTime.parse(defaultValue);
            }
            case TIMESTAMP: {
                return Instant.parse(defaultValue);
            }
            case STRING: {
                return defaultValue;
            }
            case UUID: {
                return UUID.fromString(defaultValue);
            }
            case BYTES: {
                return StringUtils.fromHexString((String)defaultValue);
            }
        }
        throw new IllegalStateException("Unknown type [type=" + String.valueOf(type) + "]");
    }

    private ValueSerializationHelper() {
    }
}

