/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.row;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite.internal.sql.engine.exec.row.BaseTypeSpec;
import org.apache.ignite.internal.sql.engine.exec.row.NullTypeSpec;
import org.apache.ignite.internal.sql.engine.exec.row.TypeSpec;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.type.NativeTypes;
import org.apache.ignite.internal.util.Pair;
import org.jetbrains.annotations.Nullable;

public final class RowSchemaTypes {
    public static final NullTypeSpec NULL = new NullTypeSpec();
    static final Map<NativeType, Pair<BaseTypeSpec, BaseTypeSpec>> INTERNED_TYPES;

    private RowSchemaTypes() {
    }

    public static BaseTypeSpec nativeType(NativeType nativeType) {
        return RowSchemaTypes.nativeTypeWithNullability(nativeType, false);
    }

    public static BaseTypeSpec nativeTypeWithNullability(NativeType nativeType, boolean nullable) {
        Pair<BaseTypeSpec, BaseTypeSpec> typePair = INTERNED_TYPES.get(nativeType);
        if (typePair != null) {
            return nullable ? (BaseTypeSpec)typePair.getSecond() : (BaseTypeSpec)typePair.getFirst();
        }
        return new BaseTypeSpec(nativeType, nullable);
    }

    @Nullable
    public static NativeType toNativeType(TypeSpec type) {
        if (type instanceof NullTypeSpec) {
            return null;
        }
        if (!(type instanceof BaseTypeSpec)) {
            throw new IllegalArgumentException("Unexpected type; " + String.valueOf(type));
        }
        NativeType nativeType = ((BaseTypeSpec)type).nativeType();
        assert (nativeType != null) : type;
        return nativeType;
    }

    static {
        List<NativeType> nativeTypeList = Arrays.asList(NativeTypes.BOOLEAN, NativeTypes.INT8, NativeTypes.INT16, NativeTypes.INT32, NativeTypes.INT64, NativeTypes.FLOAT, NativeTypes.DOUBLE, NativeTypes.STRING, NativeTypes.BYTES, NativeTypes.DATE, NativeTypes.UUID);
        INTERNED_TYPES = nativeTypeList.stream().map(t -> {
            BaseTypeSpec notNull = new BaseTypeSpec((NativeType)t, false);
            BaseTypeSpec nullable = new BaseTypeSpec((NativeType)t, true);
            return Map.entry(t, new Pair((Object)notNull, (Object)nullable));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

