/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.ignite.network.MessagingService;
import org.apache.ignite.network.NetworkMessageHandler;
import org.apache.ignite.network.annotations.MessageGroup;

public abstract class AbstractMessagingService
implements MessagingService {
    private final AtomicReferenceArray<Handler> handlersByGroupType = new AtomicReferenceArray(32768);

    @Override
    public void addMessageHandler(Class<?> messageGroup, NetworkMessageHandler handler) {
        this.handlersByGroupType.getAndUpdate(AbstractMessagingService.getMessageGroupType(messageGroup), oldHandler -> {
            if (oldHandler == null) {
                return new Handler(messageGroup, List.of(handler));
            }
            if (oldHandler.messageGroup != messageGroup) {
                throw new IllegalArgumentException(String.format("Handlers are already registered for a message group with the same group ID but different class. Group ID: %d, given message group: %s, existing message group: %s", AbstractMessagingService.getMessageGroupType(messageGroup), messageGroup, oldHandler.messageGroup));
            }
            ArrayList<NetworkMessageHandler> handlers = new ArrayList<NetworkMessageHandler>(oldHandler.handlers.size() + 1);
            handlers.addAll(oldHandler.handlers);
            handlers.add(handler);
            return new Handler(messageGroup, handlers);
        });
    }

    private static short getMessageGroupType(Class<?> messageGroup) {
        MessageGroup annotation = messageGroup.getAnnotation(MessageGroup.class);
        assert (annotation != null) : "No MessageGroup annotation present on " + messageGroup;
        short groupType = annotation.groupType();
        assert (groupType >= 0) : "Group type must not be negative";
        return groupType;
    }

    protected final Collection<NetworkMessageHandler> getMessageHandlers(short groupType) {
        assert (groupType >= 0) : "Group type must not be negative";
        Handler result = this.handlersByGroupType.get(groupType);
        return result == null ? List.of() : result.handlers;
    }

    private static class Handler {
        final Class<?> messageGroup;
        final List<NetworkMessageHandler> handlers;

        Handler(Class<?> messageGroup, List<NetworkMessageHandler> handlers) {
            this.messageGroup = messageGroup;
            this.handlers = handlers;
        }
    }
}

