/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.message;

import org.apache.ignite.internal.network.NetworkMessagesFactory;
import org.apache.ignite.internal.network.message.ScaleCubeMessage;
import org.apache.ignite.internal.network.message.ScaleCubeMessageBuilder;
import org.apache.ignite.network.serialization.MessageDeserializer;
import org.apache.ignite.network.serialization.MessageMappingException;
import org.apache.ignite.network.serialization.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;

class ScaleCubeMessageDeserializer
implements MessageDeserializer<ScaleCubeMessage> {
    private final ScaleCubeMessageBuilder msg;

    ScaleCubeMessageDeserializer(NetworkMessagesFactory messageFactory) {
        this.msg = messageFactory.scaleCubeMessage();
    }

    public Class<ScaleCubeMessage> klass() {
        return ScaleCubeMessage.class;
    }

    public ScaleCubeMessage getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.msg.dataByteArray(reader.readByteArray("dataByteArray"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.msg.headers(reader.readMap("headers", MessageCollectionItemType.STRING, MessageCollectionItemType.STRING, false));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.msg.message(reader.readMessage("message"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ScaleCubeMessage.class);
    }
}

