/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory;

import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.ignite.configuration.notifications.ConfigurationNamedListListener;
import org.apache.ignite.configuration.notifications.ConfigurationNotificationEvent;
import org.apache.ignite.internal.components.LongJvmPauseDetector;
import org.apache.ignite.internal.fileio.AsyncFileIoFactory;
import org.apache.ignite.internal.fileio.FileIoFactory;
import org.apache.ignite.internal.fileio.RandomAccessFileIoFactory;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.pagememory.configuration.schema.PersistentPageMemoryDataRegionConfiguration;
import org.apache.ignite.internal.pagememory.configuration.schema.PersistentPageMemoryDataRegionView;
import org.apache.ignite.internal.pagememory.io.PageIoRegistry;
import org.apache.ignite.internal.pagememory.persistence.PartitionMetaManager;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointManager;
import org.apache.ignite.internal.pagememory.persistence.store.FilePageStoreManager;
import org.apache.ignite.internal.schema.configuration.TableConfiguration;
import org.apache.ignite.internal.schema.configuration.TablesConfiguration;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.engine.StorageEngine;
import org.apache.ignite.internal.storage.pagememory.PersistentPageMemoryDataRegion;
import org.apache.ignite.internal.storage.pagememory.PersistentPageMemoryTableStorage;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.PersistentPageMemoryDataStorageView;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.PersistentPageMemoryStorageEngineConfiguration;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.jetbrains.annotations.Nullable;

public class PersistentPageMemoryStorageEngine
implements StorageEngine {
    public static final String ENGINE_NAME = "aipersist";
    private final String igniteInstanceName;
    private final PersistentPageMemoryStorageEngineConfiguration engineConfig;
    private final PageIoRegistry ioRegistry;
    private final Path storagePath;
    @Nullable
    private final LongJvmPauseDetector longJvmPauseDetector;
    private final Map<String, PersistentPageMemoryDataRegion> regions = new ConcurrentHashMap<String, PersistentPageMemoryDataRegion>();
    @Nullable
    private volatile FilePageStoreManager filePageStoreManager;
    @Nullable
    private volatile PartitionMetaManager partitionMetaManager;
    @Nullable
    private volatile CheckpointManager checkpointManager;

    public PersistentPageMemoryStorageEngine(String igniteInstanceName, PersistentPageMemoryStorageEngineConfiguration engineConfig, PageIoRegistry ioRegistry, Path storagePath, @Nullable LongJvmPauseDetector longJvmPauseDetector) {
        this.igniteInstanceName = igniteInstanceName;
        this.engineConfig = engineConfig;
        this.ioRegistry = ioRegistry;
        this.storagePath = storagePath;
        this.longJvmPauseDetector = longJvmPauseDetector;
    }

    public PersistentPageMemoryStorageEngineConfiguration configuration() {
        return this.engineConfig;
    }

    public void start() throws StorageException {
        int pageSize = (Integer)this.engineConfig.pageSize().value();
        try {
            AsyncFileIoFactory fileIoFactory = (Boolean)this.engineConfig.checkpoint().useAsyncFileIoFactory().value() != false ? new AsyncFileIoFactory() : new RandomAccessFileIoFactory();
            this.filePageStoreManager = new FilePageStoreManager(Loggers.forClass(FilePageStoreManager.class), this.igniteInstanceName, this.storagePath, (FileIoFactory)fileIoFactory, pageSize);
            this.filePageStoreManager.start();
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error starting file page store manager", (Throwable)e);
        }
        this.partitionMetaManager = new PartitionMetaManager(this.ioRegistry, pageSize);
        try {
            this.checkpointManager = new CheckpointManager(this.igniteInstanceName, null, this.longJvmPauseDetector, this.engineConfig.checkpoint(), this.filePageStoreManager, this.partitionMetaManager, this.regions.values(), this.ioRegistry, pageSize);
            this.checkpointManager.start();
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error starting checkpoint manager", (Throwable)e);
        }
        this.addDataRegion(this.engineConfig.defaultRegion());
        this.engineConfig.regions().listenElements((ConfigurationNamedListListener)new ConfigurationNamedListListener<PersistentPageMemoryDataRegionView>(){

            public CompletableFuture<?> onCreate(ConfigurationNotificationEvent<PersistentPageMemoryDataRegionView> ctx) {
                PersistentPageMemoryStorageEngine.this.addDataRegion((PersistentPageMemoryDataRegionConfiguration)ctx.config(PersistentPageMemoryDataRegionConfiguration.class));
                return CompletableFuture.completedFuture(null);
            }
        });
    }

    public void stop() throws StorageException {
        try {
            Stream<AutoCloseable> closeRegions = this.regions.values().stream().map(region -> region::stop);
            CheckpointManager checkpointManager = this.checkpointManager;
            FilePageStoreManager filePageStoreManager = this.filePageStoreManager;
            Stream<AutoCloseable> closeManagers = Stream.of(checkpointManager == null ? null : () -> ((CheckpointManager)checkpointManager).stop(), filePageStoreManager == null ? null : () -> ((FilePageStoreManager)filePageStoreManager).stop());
            IgniteUtils.closeAll(Stream.concat(closeManagers, closeRegions));
        }
        catch (Exception e) {
            throw new StorageException("Error when stopping components", (Throwable)e);
        }
    }

    public PersistentPageMemoryTableStorage createMvTable(TableConfiguration tableCfg, TablesConfiguration tablesCfg) throws StorageException {
        PersistentPageMemoryDataStorageView dataStorageView = (PersistentPageMemoryDataStorageView)tableCfg.dataStorage().value();
        return new PersistentPageMemoryTableStorage(this, tableCfg, this.regions.get(dataStorageView.dataRegion()), tablesCfg);
    }

    @Nullable
    public CheckpointManager checkpointManager() {
        return this.checkpointManager;
    }

    private void addDataRegion(PersistentPageMemoryDataRegionConfiguration dataRegionConfig) {
        int pageSize = (Integer)this.engineConfig.pageSize().value();
        String name = (String)dataRegionConfig.name().value();
        PersistentPageMemoryDataRegion dataRegion = new PersistentPageMemoryDataRegion(dataRegionConfig, this.ioRegistry, this.filePageStoreManager, this.partitionMetaManager, this.checkpointManager, pageSize);
        dataRegion.start();
        this.regions.put(name, dataRegion);
    }
}

