/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rel.agg;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.agg.Accumulator;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.agg.GroupKey;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRelVisitor;
import org.apache.ignite.internal.processors.query.calcite.rel.agg.IgniteHashAggregateBase;
import org.apache.ignite.internal.processors.query.calcite.rel.agg.IgniteMapAggregateBase;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;

public class IgniteMapHashAggregate
extends IgniteMapAggregateBase
implements IgniteHashAggregateBase {
    public IgniteMapHashAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        super(cluster, traitSet, input, groupSet, groupSets, aggCalls);
    }

    public IgniteMapHashAggregate(RelInput input) {
        super(input);
    }

    public Aggregate copy(RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        return new IgniteMapHashAggregate(this.getCluster(), traitSet, input, groupSet, groupSets, aggCalls);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteMapHashAggregate(cluster, this.getTraitSet(), (RelNode)IgniteMapHashAggregate.sole(inputs), this.getGroupSet(), (List<ImmutableBitSet>)this.getGroupSets(), this.getAggCallList());
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    protected RelDataType deriveRowType() {
        return IgniteMapHashAggregate.rowType((RelDataTypeFactory)Commons.typeFactory(this.getCluster()), !this.aggCalls.isEmpty());
    }

    public static RelDataType rowType(RelDataTypeFactory typeFactory, boolean addData) {
        assert (typeFactory instanceof IgniteTypeFactory);
        RelDataTypeFactory.Builder builder = new RelDataTypeFactory.Builder(typeFactory);
        builder.add("GROUP_ID", typeFactory.createJavaType(Byte.TYPE));
        builder.add("GROUP_KEY", typeFactory.createJavaType(GroupKey.class));
        if (addData) {
            builder.add("AGG_DATA", typeFactory.createArrayType(typeFactory.createJavaType(Accumulator.class), -1L));
        }
        return builder.build();
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return this.computeSelfCostHash(planner, mq);
    }
}

