/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.core.Spool;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.hint.Hintable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.util.Pair;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.query.calcite.hint.HintDefinition;
import org.apache.ignite.internal.processors.query.calcite.hint.HintUtils;
import org.apache.ignite.internal.processors.query.calcite.prepare.IgnitePlanner;
import org.apache.ignite.internal.processors.query.calcite.prepare.IgniteRelShuttle;
import org.apache.ignite.internal.processors.query.calcite.prepare.PlannerPhase;
import org.apache.ignite.internal.processors.query.calcite.rel.AbstractIndexScan;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteConvention;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteIndexScan;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteProject;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteTableModify;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteTableScan;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteTableSpool;
import org.apache.ignite.internal.processors.query.calcite.schema.ColumnDescriptor;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteTable;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistributions;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.util.typedef.F;

public class PlannerHelper {
    private PlannerHelper() {
    }

    public static IgniteRel optimize(SqlNode sqlNode, IgnitePlanner planner, IgniteLogger log) {
        try {
            RelRoot root = planner.rel(sqlNode);
            root = PlannerHelper.addExternalOptions(root);
            planner.setDisabledRules(HintUtils.options(root.rel, PlannerHelper.extractRootHints(root.rel), HintDefinition.DISABLE_RULE));
            Object rel = root.rel;
            rel = planner.transform(PlannerPhase.HEP_DECORRELATE, rel.getTraitSet(), (RelNode)rel);
            rel = RelOptUtil.propagateRelHints((RelNode)rel, (boolean)false);
            rel = planner.replaceCorrelatesCollisions((RelNode)rel);
            rel = planner.trimUnusedFields((RelRoot)root.withRel((RelNode)rel)).rel;
            rel = planner.transform(PlannerPhase.HEP_FILTER_PUSH_DOWN, rel.getTraitSet(), (RelNode)rel);
            rel = planner.transform(PlannerPhase.HEP_PROJECT_PUSH_DOWN, rel.getTraitSet(), (RelNode)rel);
            RelTraitSet desired = rel.getCluster().traitSet().replace((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)IgniteDistributions.single()).replace((RelTrait)(root.collation == null ? RelCollations.EMPTY : root.collation)).simplify();
            IgniteRel igniteRel = (IgniteRel)planner.transform(PlannerPhase.OPTIMIZATION, desired, (RelNode)rel);
            if (!root.isRefTrivial()) {
                ArrayList<RexInputRef> projects = new ArrayList<RexInputRef>();
                RexBuilder rexBuilder = igniteRel.getCluster().getRexBuilder();
                Iterator iterator = Pair.left((List)root.fields).iterator();
                while (iterator.hasNext()) {
                    int field = (Integer)iterator.next();
                    projects.add(rexBuilder.makeInputRef((RelNode)igniteRel, field));
                }
                igniteRel = new IgniteProject(igniteRel.getCluster(), desired, (RelNode)igniteRel, projects, root.validatedRowType);
            }
            if (sqlNode.isA((Set)ImmutableSet.of((Object)SqlKind.INSERT, (Object)SqlKind.UPDATE, (Object)SqlKind.MERGE))) {
                igniteRel = new FixDependentModifyNodeShuttle().visit(igniteRel);
            }
            return igniteRel;
        }
        catch (Throwable ex) {
            log.error("Unexpected error at query optimizer.", ex);
            log.error(planner.dump());
            throw ex;
        }
    }

    private static RelRoot addExternalOptions(RelRoot root) {
        if (!Commons.context(root.rel).isForcedJoinOrder()) {
            return root;
        }
        if (!(root.rel instanceof Hintable)) {
            Commons.context(root.rel).logger().warning("Unable to set hint " + HintDefinition.ENFORCE_JOIN_ORDER + " passed as an external parameter to the root relation operator [" + RelOptUtil.toString((RelNode)HintUtils.noInputsRelWrap(root.rel)).trim() + "] because it is not a Hintable.");
            return root;
        }
        List newHints = Stream.concat(HintUtils.allRelHints(root.rel).stream(), Stream.of(RelHint.builder((String)HintDefinition.ENFORCE_JOIN_ORDER.name()).build())).collect(Collectors.toList());
        root = root.withRel(((Hintable)root.rel).withHints(newHints));
        RelOptUtil.propagateRelHints((RelNode)root.rel, (boolean)false);
        return root;
    }

    private static Collection<RelHint> extractRootHints(RelNode rel) {
        if (!HintUtils.allRelHints(rel).isEmpty()) {
            return HintUtils.allRelHints(rel);
        }
        if (rel instanceof SetOp) {
            return F.flatCollections((Collection)rel.getInputs().stream().map(PlannerHelper::extractRootHints).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    private static class FixDependentModifyNodeShuttle
    extends IgniteRelShuttle {
        private boolean spoolNeeded;
        private IgniteTableModify modifyNode;

        private FixDependentModifyNodeShuttle() {
        }

        @Override
        public IgniteRel visit(IgniteTableModify rel) {
            assert (this.modifyNode == null);
            this.modifyNode = rel;
            if (rel.isDelete()) {
                return rel;
            }
            if (rel.isMerge()) {
                this.spoolNeeded = true;
            } else {
                this.processNode(rel);
            }
            if (this.spoolNeeded) {
                IgniteTableSpool spool = new IgniteTableSpool(rel.getCluster(), rel.getInput().getTraitSet(), Spool.Type.EAGER, rel.getInput());
                rel.replaceInput(0, (RelNode)spool);
            }
            return rel;
        }

        @Override
        public IgniteRel visit(IgniteTableScan rel) {
            return this.processScan(rel);
        }

        @Override
        public IgniteRel visit(IgniteIndexScan rel) {
            return this.processScan(rel);
        }

        @Override
        protected IgniteRel processNode(IgniteRel rel) {
            List inputs = Commons.cast(rel.getInputs());
            for (int i = 0; i < inputs.size() && !this.spoolNeeded; ++i) {
                this.visitChild(rel, i, (IgniteRel)inputs.get(i));
            }
            return rel;
        }

        private IgniteRel processScan(TableScan scan) {
            IgniteTable tbl;
            IgniteTable igniteTable = tbl = this.modifyNode != null ? (IgniteTable)this.modifyNode.getTable().unwrap(IgniteTable.class) : null;
            if (tbl == null || scan.getTable().unwrap(IgniteTable.class) != tbl) {
                return (IgniteRel)scan;
            }
            if (this.modifyNodeInsertsData()) {
                this.spoolNeeded = true;
                return (IgniteRel)scan;
            }
            if (scan instanceof IgniteTableScan) {
                return (IgniteRel)scan;
            }
            ImmutableSet indexedCols = ImmutableSet.copyOf((Collection)tbl.getIndex(((AbstractIndexScan)scan).indexName()).collation().getKeys());
            this.spoolNeeded = this.modifyNode.getUpdateColumnList().stream().map(tbl.descriptor()::columnDescriptor).map(ColumnDescriptor::fieldIndex).anyMatch(arg_0 -> ((ImmutableSet)indexedCols).contains(arg_0));
            return (IgniteRel)scan;
        }

        private boolean modifyNodeInsertsData() {
            return this.modifyNode.isInsert();
        }
    }
}

