/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import java.io.IOException;
import java.util.concurrent.Future;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.CompletingFutureContribution;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.testing.nio.AsyncRequester;
import org.apache.hc.core5.testing.nio.ClientSessionEndpoint;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.Timeout;

public abstract class HttpTestClient
extends AsyncRequester {
    final SSLContext sslContext;
    final SSLSessionInitializer sslSessionInitializer;
    final SSLSessionVerifier sslSessionVerifier;
    HttpProcessor httpProcessor;

    public HttpTestClient(IOReactorConfig ioReactorConfig, SSLContext sslContext, SSLSessionInitializer sslSessionInitializer, SSLSessionVerifier sslSessionVerifier) throws IOException {
        super(ioReactorConfig);
        this.sslContext = sslContext;
        this.sslSessionInitializer = sslSessionInitializer;
        this.sslSessionVerifier = sslSessionVerifier;
    }

    public HttpTestClient() throws IOException {
        this(IOReactorConfig.DEFAULT, null, null, null);
    }

    public abstract void start() throws Exception;

    void ensureNotRunning() {
        Asserts.check((this.getStatus() == IOReactorStatus.INACTIVE ? 1 : 0) != 0, (String)"Client is already running");
    }

    public void configure(HttpProcessor httpProcessor) {
        this.ensureNotRunning();
        this.httpProcessor = httpProcessor;
    }

    public Future<ClientSessionEndpoint> connect(HttpHost host, Timeout timeout, FutureCallback<ClientSessionEndpoint> callback) {
        BasicFuture future = new BasicFuture(callback);
        this.requestSession(host, timeout, (FutureCallback<IOSession>)new CompletingFutureContribution(future, ClientSessionEndpoint::new));
        return future;
    }

    public Future<ClientSessionEndpoint> connect(HttpHost host, Timeout timeout) {
        return this.connect(host, timeout, null);
    }

    public Future<ClientSessionEndpoint> connect(String hostname, int port, Timeout timeout) {
        return this.connect(new HttpHost(hostname, port), timeout, null);
    }

    public void startExecution(IOEventHandlerFactory handlerFactory) throws IOException {
        super.execute(handlerFactory);
    }
}

