/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.classic;

import java.net.SocketException;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.ExceptionListener;
import org.apache.hc.core5.http.HttpConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingExceptionListener
implements ExceptionListener {
    public static final LoggingExceptionListener INSTANCE = new LoggingExceptionListener();
    private final Logger connLog = LoggerFactory.getLogger((String)"org.apache.hc.core5.http.connection");

    public void onError(Exception ex) {
        if (ex instanceof SocketException) {
            this.connLog.debug(ex.getMessage());
        } else {
            this.connLog.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public void onError(HttpConnection conn, Exception ex) {
        if (ex instanceof ConnectionClosedException) {
            this.connLog.debug(ex.getMessage());
        } else if (ex instanceof SocketException) {
            this.connLog.debug(ex.getMessage());
        } else {
            this.connLog.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

