/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.CollectionExpression;
import org.datanucleus.store.rdbms.sql.expression.IllegalExpressionOperationException;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.ObjectLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;

public class CollectionLiteral
extends CollectionExpression
implements SQLLiteral {
    private final Collection value;
    private List<SQLExpression> elementExpressions;

    public CollectionLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value, String parameterName) {
        super(stmt, null, mapping);
        this.parameterName = parameterName;
        if (value == null) {
            this.value = null;
        } else if (parameterName != null) {
            this.value = value instanceof Collection ? (Collection)value : null;
            this.st.appendParameter(parameterName, mapping, this.value);
        } else if (value instanceof Collection) {
            this.value = (Collection)value;
            this.setStatement();
        } else {
            throw new NucleusException("Cannot create " + this.getClass().getName() + " for value of type " + value.getClass().getName());
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public List<SQLExpression> getElementExpressions() {
        return this.elementExpressions;
    }

    @Override
    public void setNotParameter() {
        if (this.parameterName == null) {
            return;
        }
        this.parameterName = null;
        this.st.clearStatement();
        this.setStatement();
    }

    protected void setStatement() {
        if (this.value != null && this.value.size() > 0) {
            RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
            this.elementExpressions = new ArrayList<SQLExpression>();
            this.st.append("(");
            boolean hadPrev = false;
            for (Object element : this.value) {
                if (element == null) continue;
                JavaTypeMapping elemMapping = storeMgr.getSQLExpressionFactory().getMappingForType(element.getClass(), false);
                SQLExpression elemExpr = storeMgr.getSQLExpressionFactory().newLiteral(this.stmt, elemMapping, element);
                this.st.append(hadPrev ? "," : "");
                this.st.append(elemExpr);
                this.elementExpressions.add(elemExpr);
                hadPrev = true;
            }
            this.st.append(")");
        }
    }

    @Override
    public SQLExpression invoke(String methodName, List<SQLExpression> args) {
        if (methodName.equals("get") && args.size() == 1 && this.value instanceof List) {
            SQLExpression argExpr = args.get(0);
            if (argExpr instanceof SQLLiteral) {
                Object val = ((List)this.value).get((Integer)((SQLLiteral)((Object)argExpr)).getValue());
                if (val == null) {
                    return new NullLiteral(this.stmt, null, null, null);
                }
                JavaTypeMapping m = this.stmt.getRDBMSManager().getSQLExpressionFactory().getMappingForType(val.getClass(), false);
                return new ObjectLiteral(this.stmt, m, val, null);
            }
            throw new IllegalExpressionOperationException(this, "get", argExpr);
        }
        return super.invoke(methodName, args);
    }
}

