/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.ColumnLengthDefiningTypeConverter;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;

public class CalendarStringConverter
implements TypeConverter<Calendar, String>,
ColumnLengthDefiningTypeConverter {
    private static final long serialVersionUID = -4905708644688677004L;

    @Override
    public int getDefaultColumnLength(int columnPosition) {
        if (columnPosition != 0) {
            return -1;
        }
        return 28;
    }

    @Override
    public Calendar toMemberType(String str) {
        if (str == null) {
            return null;
        }
        try {
            Instant inst = Instant.parse(str);
            ZonedDateTime zdt = ZonedDateTime.ofInstant(inst, ZoneId.systemDefault());
            return GregorianCalendar.from(zdt);
        }
        catch (DateTimeParseException pe) {
            throw new NucleusDataStoreException(Localiser.msg("016002", str, Calendar.class.getName()), pe);
        }
    }

    @Override
    public String toDatastoreType(Calendar cal) {
        return cal != null ? cal.toInstant().toString() : null;
    }
}

