/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri.shims;

import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Date;
import java.util.TimeZone;

public class HiveShims {
    public static Long getPrimitiveEpoch(Object prim, TimeZone tz) {
        if (prim instanceof Timestamp) {
            return ((Timestamp)prim).getTime();
        }
        if (prim instanceof Date) {
            return ((Date)prim).getTime();
        }
        try {
            Class<?> dtClazz = Class.forName("org.apache.hadoop.hive.common.type.Date");
            if (prim.getClass() == dtClazz) {
                Method dtGetImpl = dtClazz.getMethod("toEpochMilli", new Class[0]);
                return (Long)dtGetImpl.invoke(prim, new Object[0]);
            }
            Class<?> ttClazz = Class.forName("org.apache.hadoop.hive.common.type.Timestamp");
            if (prim.getClass() == ttClazz) {
                Method ttGetImpl = ttClazz.getMethod("toEpochMilli", new Class[0]);
                return (Long)ttGetImpl.invoke(prim, new Object[0]);
            }
            return null;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public static void setDateWritable(Object dwHive, long epoch, TimeZone tz) {
        try {
            Class<?> dtClazz = Class.forName("org.apache.hadoop.hive.common.type.Date");
            Class<?> dwClazz = Class.forName("org.apache.hadoop.hive.serde2.io.DateWritableV2");
            Method dtSetImpl = dtClazz.getMethod("setTimeInMillis", Long.TYPE);
            Method dwSetImpl = dwClazz.getMethod("set", dtClazz);
            Object dtObj = dtClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            dtSetImpl.invoke(dtObj, epoch);
            dwSetImpl.invoke(dwHive, dtObj);
        }
        catch (Exception e1) {
            try {
                Class<?> dwClazz = Class.forName("org.apache.hadoop.hive.serde2.io.DateWritable");
                Method dwSetImpl = dwClazz.getMethod("set", java.sql.Date.class);
                dwSetImpl.invoke(dwHive, new java.sql.Date(epoch));
            }
            catch (Exception e2) {
                throw new UnsupportedOperationException("DATE type");
            }
        }
    }

    public static void setDateWritable(Object dwHive, java.sql.Date jsd) {
        try {
            Class<?> dtClazz = Class.forName("org.apache.hadoop.hive.common.type.Date");
            Class<?> dwClazz = Class.forName("org.apache.hadoop.hive.serde2.io.DateWritableV2");
            Method dtSetImpl = dtClazz.getMethod("setTimeInMillis", Long.TYPE);
            Method dwSetImpl = dwClazz.getMethod("set", dtClazz);
            Object dtObj = dtClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            dtSetImpl.invoke(dtObj, jsd.getTime());
            dwSetImpl.invoke(dwHive, dtObj);
        }
        catch (Exception e1) {
            try {
                Class<?> dwClazz = Class.forName("org.apache.hadoop.hive.serde2.io.DateWritable");
                Method dwSetImpl = dwClazz.getMethod("set", java.sql.Date.class);
                dwSetImpl.invoke(dwHive, jsd);
            }
            catch (Exception e2) {
                throw new UnsupportedOperationException("DATE type");
            }
        }
    }

    public static void setTimeWritable(Object twHive, long epoch) {
        try {
            Class<?> ttClazz = Class.forName("org.apache.hadoop.hive.common.type.Timestamp");
            Class<?> twClazz = Class.forName("org.apache.hadoop.hive.serde2.io.TimestampWritableV2");
            Method ttSetImpl = ttClazz.getMethod("setTimeInMillis", Long.TYPE);
            Method twSetImpl = twClazz.getMethod("set", ttClazz);
            Object ttObj = ttClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            ttSetImpl.invoke(ttObj, epoch);
            twSetImpl.invoke(twHive, ttObj);
        }
        catch (Exception e1) {
            try {
                Class<?> twClazz = Class.forName("org.apache.hadoop.hive.serde2.io.TimestampWritable");
                Method twSetImpl = twClazz.getMethod("set", Timestamp.class);
                twSetImpl.invoke(twHive, new Timestamp(epoch));
            }
            catch (Exception e2) {
                throw new UnsupportedOperationException("TIMESTAMP type");
            }
        }
    }

    public static void setTimeWritable(Object twHive, Timestamp jst) {
        long epoch = jst.getTime();
        try {
            Class<?> ttClazz = Class.forName("org.apache.hadoop.hive.common.type.Timestamp");
            Class<?> twClazz = Class.forName("org.apache.hadoop.hive.serde2.io.TimestampWritableV2");
            Method ttSetImpl = ttClazz.getMethod("setTimeInMillis", Long.TYPE);
            Method twSetImpl = twClazz.getMethod("set", ttClazz);
            Object ttObj = ttClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            ttSetImpl.invoke(ttObj, epoch);
            twSetImpl.invoke(twHive, ttObj);
        }
        catch (Exception e1) {
            try {
                Class<?> twClazz = Class.forName("org.apache.hadoop.hive.serde2.io.TimestampWritable");
                Method twSetImpl = twClazz.getMethod("set", Timestamp.class);
                twSetImpl.invoke(twHive, new Timestamp(epoch));
            }
            catch (Exception e2) {
                throw new UnsupportedOperationException("TIMESTAMP type");
            }
        }
    }

    public static class serdeConstants {
        public static final String LIST_COLUMNS;
        public static final String LIST_COLUMN_TYPES;

        static String getAsStringOrNull(Class<?> clazz, String constant) {
            try {
                return (String)clazz.getField(constant).get(null);
            }
            catch (Exception e) {
                return null;
            }
        }

        static {
            Class<?> clazz = null;
            try {
                clazz = Class.forName("org.apache.hadoop.hive.serde.serdeConstants");
            }
            catch (ClassNotFoundException e) {
                try {
                    clazz = Class.forName("org.apache.hadoop.hive.serde.Constants");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            LIST_COLUMNS = serdeConstants.getAsStringOrNull(clazz, "LIST_COLUMNS");
            LIST_COLUMN_TYPES = serdeConstants.getAsStringOrNull(clazz, "LIST_COLUMN_TYPES");
        }
    }
}

