/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Delegates;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Types;

class V3Metadata {
    static final Schema MANIFEST_LIST_SCHEMA = new Schema(ManifestFile.PATH, ManifestFile.LENGTH, ManifestFile.SPEC_ID, ManifestFile.MANIFEST_CONTENT.asRequired(), ManifestFile.SEQUENCE_NUMBER.asRequired(), ManifestFile.MIN_SEQUENCE_NUMBER.asRequired(), ManifestFile.SNAPSHOT_ID, ManifestFile.ADDED_FILES_COUNT.asRequired(), ManifestFile.EXISTING_FILES_COUNT.asRequired(), ManifestFile.DELETED_FILES_COUNT.asRequired(), ManifestFile.ADDED_ROWS_COUNT.asRequired(), ManifestFile.EXISTING_ROWS_COUNT.asRequired(), ManifestFile.DELETED_ROWS_COUNT.asRequired(), ManifestFile.PARTITION_SUMMARIES, ManifestFile.KEY_METADATA, ManifestFile.FIRST_ROW_ID);

    private V3Metadata() {
    }

    static Schema entrySchema(Types.StructType partitionType) {
        return V3Metadata.wrapFileSchema(V3Metadata.fileType(partitionType));
    }

    static Schema wrapFileSchema(Types.StructType fileSchema) {
        return new Schema(ManifestEntry.STATUS, ManifestEntry.SNAPSHOT_ID, ManifestEntry.SEQUENCE_NUMBER, ManifestEntry.FILE_SEQUENCE_NUMBER, Types.NestedField.required(2, "data_file", fileSchema));
    }

    static Types.StructType fileType(Types.StructType partitionType) {
        return Types.StructType.of(DataFile.CONTENT.asRequired(), DataFile.FILE_PATH, DataFile.FILE_FORMAT, Types.NestedField.required(102, "partition", partitionType, "Partition data tuple, schema based on the partition spec"), DataFile.RECORD_COUNT, DataFile.FILE_SIZE, DataFile.COLUMN_SIZES, DataFile.VALUE_COUNTS, DataFile.NULL_VALUE_COUNTS, DataFile.NAN_VALUE_COUNTS, DataFile.LOWER_BOUNDS, DataFile.UPPER_BOUNDS, DataFile.KEY_METADATA, DataFile.SPLIT_OFFSETS, DataFile.EQUALITY_IDS, DataFile.SORT_ORDER_ID, DataFile.FIRST_ROW_ID, DataFile.REFERENCED_DATA_FILE, DataFile.CONTENT_OFFSET, DataFile.CONTENT_SIZE);
    }

    static class DataFileWrapper<F extends ContentFile<F>>
    extends Delegates.DelegatingContentFile<F>
    implements ContentFile<F>,
    StructLike {
        private final int size = V3Metadata.fileType(Types.StructType.of(new Types.NestedField[0])).fields().size();

        DataFileWrapper() {
            super(null);
        }

        DataFileWrapper<F> wrap(ContentFile<?> file) {
            this.setWrapped(file);
            return this;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public <T> void set(int pos, T value) {
            throw new UnsupportedOperationException("Cannot modify DataFileWrapper wrapper via set");
        }

        @Override
        public <T> T get(int pos, Class<T> javaClass) {
            return javaClass.cast(this.get(pos));
        }

        private Object get(int pos) {
            switch (pos) {
                case 0: {
                    return this.wrapped.content().id();
                }
                case 1: {
                    return this.wrapped.location();
                }
                case 2: {
                    return this.wrapped.format() != null ? this.wrapped.format().toString() : null;
                }
                case 3: {
                    return this.wrapped.partition();
                }
                case 4: {
                    return this.wrapped.recordCount();
                }
                case 5: {
                    return this.wrapped.fileSizeInBytes();
                }
                case 6: {
                    return this.wrapped.columnSizes();
                }
                case 7: {
                    return this.wrapped.valueCounts();
                }
                case 8: {
                    return this.wrapped.nullValueCounts();
                }
                case 9: {
                    return this.wrapped.nanValueCounts();
                }
                case 10: {
                    return this.wrapped.lowerBounds();
                }
                case 11: {
                    return this.wrapped.upperBounds();
                }
                case 12: {
                    return this.wrapped.keyMetadata();
                }
                case 13: {
                    return this.wrapped.splitOffsets();
                }
                case 14: {
                    return this.wrapped.equalityFieldIds();
                }
                case 15: {
                    return this.wrapped.sortOrderId();
                }
                case 16: {
                    if (this.wrapped.content() == FileContent.DATA) {
                        return this.wrapped.firstRowId();
                    }
                    return null;
                }
                case 17: {
                    if (this.wrapped.content() == FileContent.POSITION_DELETES) {
                        return ((DeleteFile)this.wrapped).referencedDataFile();
                    }
                    return null;
                }
                case 18: {
                    if (this.wrapped.content() == FileContent.POSITION_DELETES) {
                        return ((DeleteFile)this.wrapped).contentOffset();
                    }
                    return null;
                }
                case 19: {
                    if (this.wrapped.content() == FileContent.POSITION_DELETES) {
                        return ((DeleteFile)this.wrapped).contentSizeInBytes();
                    }
                    return null;
                }
            }
            throw new IllegalArgumentException("Unknown field ordinal: " + pos);
        }

        @Override
        public String manifestLocation() {
            return null;
        }

        @Override
        public Long pos() {
            return null;
        }
    }

    static class ManifestEntryWrapper<F extends ContentFile<F>>
    implements ManifestEntry<F>,
    StructLike {
        private final int size = V3Metadata.entrySchema(Types.StructType.of(new Types.NestedField[0])).columns().size();
        private final Long commitSnapshotId;
        private final DataFileWrapper<?> fileWrapper;
        private ManifestEntry<F> wrapped = null;

        ManifestEntryWrapper(Long commitSnapshotId) {
            this.commitSnapshotId = commitSnapshotId;
            this.fileWrapper = new DataFileWrapper();
        }

        public ManifestEntryWrapper<F> wrap(ManifestEntry<F> entry) {
            this.wrapped = entry;
            return this;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public <T> void set(int pos, T value) {
            throw new UnsupportedOperationException("Cannot modify ManifestEntryWrapper wrapper via set");
        }

        @Override
        public <T> T get(int pos, Class<T> javaClass) {
            return javaClass.cast(this.get(pos));
        }

        private Object get(int pos) {
            switch (pos) {
                case 0: {
                    return this.wrapped.status().id();
                }
                case 1: {
                    return this.wrapped.snapshotId();
                }
                case 2: {
                    if (this.wrapped.dataSequenceNumber() == null) {
                        Preconditions.checkState(this.wrapped.snapshotId() == null || this.wrapped.snapshotId().equals(this.commitSnapshotId), "Found unassigned sequence number for an entry from snapshot: %s", (Object)this.wrapped.snapshotId());
                        Preconditions.checkState(this.wrapped.status() == ManifestEntry.Status.ADDED, "Only entries with status ADDED can have null sequence number");
                        return null;
                    }
                    return this.wrapped.dataSequenceNumber();
                }
                case 3: {
                    return this.wrapped.fileSequenceNumber();
                }
                case 4: {
                    return this.fileWrapper.wrap((ContentFile<?>)this.wrapped.file());
                }
            }
            throw new UnsupportedOperationException("Unknown field ordinal: " + pos);
        }

        @Override
        public ManifestEntry.Status status() {
            return this.wrapped.status();
        }

        @Override
        public Long snapshotId() {
            return this.wrapped.snapshotId();
        }

        @Override
        public void setSnapshotId(long snapshotId) {
            this.wrapped.setSnapshotId(snapshotId);
        }

        @Override
        public Long dataSequenceNumber() {
            return this.wrapped.dataSequenceNumber();
        }

        @Override
        public void setDataSequenceNumber(long dataSequenceNumber) {
            this.wrapped.setDataSequenceNumber(dataSequenceNumber);
        }

        @Override
        public Long fileSequenceNumber() {
            return this.wrapped.fileSequenceNumber();
        }

        @Override
        public void setFileSequenceNumber(long fileSequenceNumber) {
            this.wrapped.setFileSequenceNumber(fileSequenceNumber);
        }

        @Override
        public F file() {
            return this.wrapped.file();
        }

        @Override
        public ManifestEntry<F> copy() {
            return this.wrapped.copy();
        }

        @Override
        public ManifestEntry<F> copyWithoutStats() {
            return this.wrapped.copyWithoutStats();
        }
    }

    static class ManifestFileWrapper
    implements ManifestFile,
    StructLike {
        private final long commitSnapshotId;
        private final long sequenceNumber;
        private ManifestFile wrapped = null;
        private Long wrappedFirstRowId = null;

        ManifestFileWrapper(long commitSnapshotId, long sequenceNumber) {
            this.commitSnapshotId = commitSnapshotId;
            this.sequenceNumber = sequenceNumber;
        }

        public ManifestFile wrap(ManifestFile file, Long firstRowId) {
            this.wrapped = file;
            this.wrappedFirstRowId = firstRowId;
            return this;
        }

        @Override
        public int size() {
            return MANIFEST_LIST_SCHEMA.columns().size();
        }

        @Override
        public <T> void set(int pos, T value) {
            throw new UnsupportedOperationException("Cannot modify ManifestFileWrapper wrapper via set");
        }

        @Override
        public <T> T get(int pos, Class<T> javaClass) {
            return javaClass.cast(this.get(pos));
        }

        private Object get(int pos) {
            switch (pos) {
                case 0: {
                    return this.wrapped.path();
                }
                case 1: {
                    return this.wrapped.length();
                }
                case 2: {
                    return this.wrapped.partitionSpecId();
                }
                case 3: {
                    return this.wrapped.content().id();
                }
                case 4: {
                    if (this.wrapped.sequenceNumber() == -1L) {
                        Preconditions.checkState(this.commitSnapshotId == this.wrapped.snapshotId(), "Found unassigned sequence number for a manifest from snapshot: %s", (Object)this.wrapped.snapshotId());
                        return this.sequenceNumber;
                    }
                    return this.wrapped.sequenceNumber();
                }
                case 5: {
                    if (this.wrapped.minSequenceNumber() == -1L) {
                        Preconditions.checkState(this.commitSnapshotId == this.wrapped.snapshotId(), "Found unassigned sequence number for a manifest from snapshot: %s", (Object)this.wrapped.snapshotId());
                        return this.sequenceNumber;
                    }
                    return this.wrapped.minSequenceNumber();
                }
                case 6: {
                    return this.wrapped.snapshotId();
                }
                case 7: {
                    return this.wrapped.addedFilesCount();
                }
                case 8: {
                    return this.wrapped.existingFilesCount();
                }
                case 9: {
                    return this.wrapped.deletedFilesCount();
                }
                case 10: {
                    return this.wrapped.addedRowsCount();
                }
                case 11: {
                    return this.wrapped.existingRowsCount();
                }
                case 12: {
                    return this.wrapped.deletedRowsCount();
                }
                case 13: {
                    return this.wrapped.partitions();
                }
                case 14: {
                    return this.wrapped.keyMetadata();
                }
                case 15: {
                    if (this.wrappedFirstRowId != null) {
                        Preconditions.checkState(this.wrapped.content() == ManifestContent.DATA && this.wrapped.firstRowId() == null, "Found invalid first-row-id assignment: %s", (Object)this.wrapped);
                        return this.wrappedFirstRowId;
                    }
                    if (this.wrapped.content() != ManifestContent.DATA) {
                        return null;
                    }
                    Preconditions.checkState(this.wrapped.firstRowId() != null, "Found unassigned first-row-id for file: " + this.wrapped.path());
                    return this.wrapped.firstRowId();
                }
            }
            throw new UnsupportedOperationException("Unknown field ordinal: " + pos);
        }

        @Override
        public String path() {
            return this.wrapped.path();
        }

        @Override
        public long length() {
            return this.wrapped.length();
        }

        @Override
        public int partitionSpecId() {
            return this.wrapped.partitionSpecId();
        }

        @Override
        public ManifestContent content() {
            return this.wrapped.content();
        }

        @Override
        public long sequenceNumber() {
            return this.wrapped.sequenceNumber();
        }

        @Override
        public long minSequenceNumber() {
            return this.wrapped.minSequenceNumber();
        }

        @Override
        public Long snapshotId() {
            return this.wrapped.snapshotId();
        }

        @Override
        public boolean hasAddedFiles() {
            return this.wrapped.hasAddedFiles();
        }

        @Override
        public Integer addedFilesCount() {
            return this.wrapped.addedFilesCount();
        }

        @Override
        public Long addedRowsCount() {
            return this.wrapped.addedRowsCount();
        }

        @Override
        public boolean hasExistingFiles() {
            return this.wrapped.hasExistingFiles();
        }

        @Override
        public Integer existingFilesCount() {
            return this.wrapped.existingFilesCount();
        }

        @Override
        public Long existingRowsCount() {
            return this.wrapped.existingRowsCount();
        }

        @Override
        public boolean hasDeletedFiles() {
            return this.wrapped.hasDeletedFiles();
        }

        @Override
        public Integer deletedFilesCount() {
            return this.wrapped.deletedFilesCount();
        }

        @Override
        public Long deletedRowsCount() {
            return this.wrapped.deletedRowsCount();
        }

        @Override
        public List<ManifestFile.PartitionFieldSummary> partitions() {
            return this.wrapped.partitions();
        }

        @Override
        public ByteBuffer keyMetadata() {
            return this.wrapped.keyMetadata();
        }

        @Override
        public Long firstRowId() {
            return this.wrapped.firstRowId();
        }

        @Override
        public ManifestFile copy() {
            return this.wrapped.copy();
        }
    }
}

