/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.modbus.readwrite.DriverType;
import org.apache.plc4x.java.modbus.readwrite.ModbusADU;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDU;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ModbusTcpADU
extends ModbusADU
implements Message {
    public static final Integer PROTOCOLIDENTIFIER = 0;
    protected final int transactionIdentifier;
    protected final short unitIdentifier;
    protected final ModbusPDU pdu;

    @Override
    public DriverType getDriverType() {
        return DriverType.MODBUS_TCP;
    }

    public ModbusTcpADU(int transactionIdentifier, short unitIdentifier, ModbusPDU pdu) {
        this.transactionIdentifier = transactionIdentifier;
        this.unitIdentifier = unitIdentifier;
        this.pdu = pdu;
    }

    public int getTransactionIdentifier() {
        return this.transactionIdentifier;
    }

    public short getUnitIdentifier() {
        return this.unitIdentifier;
    }

    public ModbusPDU getPdu() {
        return this.pdu;
    }

    public int getProtocolIdentifier() {
        return PROTOCOLIDENTIFIER;
    }

    @Override
    protected void serializeModbusADUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ModbusTcpADU", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"transactionIdentifier", (Object)this.transactionIdentifier, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        FieldWriterFactory.writeConstField((String)"protocolIdentifier", (Object)PROTOCOLIDENTIFIER, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        int length = this.getPdu().getLengthInBytes() + 1;
        FieldWriterFactory.writeImplicitField((String)"length", (Object)length, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        FieldWriterFactory.writeSimpleField((String)"unitIdentifier", (Object)this.unitIdentifier, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        FieldWriterFactory.writeSimpleField((String)"pdu", (Object)this.pdu, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        writeBuffer.popContext("ModbusTcpADU", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        ModbusTcpADU _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 8;
        return lengthInBits += this.pdu.getLengthInBits();
    }

    public static ModbusADU.ModbusADUBuilder staticParseModbusADUBuilder(ReadBuffer readBuffer, DriverType driverType, Boolean response) throws ParseException {
        readBuffer.pullContext("ModbusTcpADU", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int transactionIdentifier = (Integer)FieldReaderFactory.readSimpleField((String)"transactionIdentifier", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        int protocolIdentifier = (Integer)FieldReaderFactory.readConstField((String)"protocolIdentifier", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (Object)PROTOCOLIDENTIFIER, (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        int length = (Integer)FieldReaderFactory.readImplicitField((String)"length", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        short unitIdentifier = (Short)FieldReaderFactory.readSimpleField((String)"unitIdentifier", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        ModbusPDU pdu = (ModbusPDU)FieldReaderFactory.readSimpleField((String)"pdu", (DataReader)new DataReaderComplexDefault(() -> ModbusPDU.staticParse(readBuffer, (boolean)response), readBuffer), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        readBuffer.closeContext("ModbusTcpADU", new WithReaderArgs[0]);
        return new ModbusTcpADUBuilderImpl(transactionIdentifier, unitIdentifier, pdu);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModbusTcpADU)) {
            return false;
        }
        ModbusTcpADU that = (ModbusTcpADU)o;
        return this.getTransactionIdentifier() == that.getTransactionIdentifier() && this.getUnitIdentifier() == that.getUnitIdentifier() && this.getPdu() == that.getPdu() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getTransactionIdentifier(), this.getUnitIdentifier(), this.getPdu());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ModbusTcpADUBuilderImpl
    implements ModbusADU.ModbusADUBuilder {
        private final int transactionIdentifier;
        private final short unitIdentifier;
        private final ModbusPDU pdu;

        public ModbusTcpADUBuilderImpl(int transactionIdentifier, short unitIdentifier, ModbusPDU pdu) {
            this.transactionIdentifier = transactionIdentifier;
            this.unitIdentifier = unitIdentifier;
            this.pdu = pdu;
        }

        @Override
        public ModbusTcpADU build() {
            ModbusTcpADU modbusTcpADU = new ModbusTcpADU(this.transactionIdentifier, this.unitIdentifier, this.pdu);
            return modbusTcpADU;
        }
    }
}

