/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.limit;

import com.codahale.metrics.Timer;
import io.greptime.common.util.Clock;
import io.greptime.common.util.MetricsUtil;
import io.greptime.errors.LimitedException;
import io.greptime.limit.Limiter;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class InFlightLimiter
implements Limiter {
    private final int permits;
    private final Semaphore semaphore;
    private final Timer acquireTimer;

    public InFlightLimiter(int permits, String metricPrefix) {
        this.permits = permits;
        this.semaphore = new Semaphore(permits);
        this.acquireTimer = MetricsUtil.timer((Object[])new Object[]{metricPrefix, "wait_time"});
    }

    @Override
    public void acquire(int permits) {
        long startCall = Clock.defaultClock().getTick();
        try {
            this.semaphore.acquire(permits);
        }
        catch (InterruptedException e) {
            throw new LimitedException(e);
        }
        finally {
            this.acquireTimer.update(Clock.defaultClock().duration(startCall), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) {
        long startCall = Clock.defaultClock().getTick();
        try {
            boolean bl = this.semaphore.tryAcquire(permits, timeout, unit);
            return bl;
        }
        catch (InterruptedException e) {
            throw new LimitedException(e);
        }
        finally {
            this.acquireTimer.update(Clock.defaultClock().duration(startCall), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void release(int permits) {
        this.semaphore.release(permits);
    }

    @Override
    public int availablePermits() {
        return this.semaphore.availablePermits();
    }

    @Override
    public int maxPermits() {
        return this.permits;
    }
}

