/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.security;

import com.usthe.sureness.security.XssSqlUtil;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class XssSqlServletRequestWrapper
extends HttpServletRequestWrapper {
    public XssSqlServletRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public String[] getParameterValues(String parameter) {
        String[] values = super.getParameterValues(parameter);
        if (values == null) {
            return null;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        for (int i = 0; i < count; ++i) {
            encodedValues[i] = this.filterParamString(values[i]);
        }
        return encodedValues;
    }

    public Map<String, String[]> getParameterMap() {
        Map primary = super.getParameterMap();
        HashMap<String, String[]> result = new HashMap<String, String[]>(16);
        for (Map.Entry entry : primary.entrySet()) {
            result.put((String)entry.getKey(), this.filterEntryString((String[])entry.getValue()));
        }
        return result;
    }

    public String getParameter(String parameter) {
        return this.filterParamString(super.getParameter(parameter));
    }

    public String getHeader(String name) {
        return this.filterParamString(super.getHeader(name));
    }

    public Cookie[] getCookies() {
        Cookie[] cookies = super.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                cookie.setValue(this.filterParamString(cookie.getValue()));
            }
        }
        return cookies;
    }

    private String[] filterEntryString(String[] value) {
        for (int i = 0; i < value.length; ++i) {
            value[i] = this.filterParamString(value[i]);
        }
        return value;
    }

    private String filterParamString(String value) {
        return value == null ? null : XssSqlUtil.stripSqlXss(value);
    }
}

