/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.HashMap;
import java.util.Map;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.HelixManager;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.common.PartitionStateMap;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.pipeline.AbstractAsyncBaseStage;
import org.apache.helix.controller.pipeline.AsyncWorkerType;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.IntermediateStateOutput;
import org.apache.helix.model.BuiltInStateModelDefinitions;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.MaintenanceSignal;
import org.apache.helix.model.Partition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaintenanceRecoveryStage
extends AbstractAsyncBaseStage {
    private static Logger LOG = LoggerFactory.getLogger(MaintenanceRecoveryStage.class);

    @Override
    public AsyncWorkerType getAsyncWorkerType() {
        return AsyncWorkerType.MaintenanceRecoveryWorker;
    }

    @Override
    public void execute(ClusterEvent event) throws Exception {
        String reason;
        boolean shouldExitMaintenance;
        ResourceControllerDataProvider cache = (ResourceControllerDataProvider)event.getAttribute(AttributeName.ControllerDataProvider.name());
        if (cache == null) {
            return;
        }
        if (cache.hasMaintenanceSignalChanged()) {
            return;
        }
        MaintenanceSignal maintenanceSignal = cache.getMaintenanceSignal();
        if (maintenanceSignal == null || maintenanceSignal.getTriggeringEntity() != MaintenanceSignal.TriggeringEntity.CONTROLLER) {
            return;
        }
        HelixManager manager = (HelixManager)event.getAttribute(AttributeName.helixmanager.name());
        if (manager == null || !manager.isConnected()) {
            LogUtil.logInfo(LOG, this._eventId, "MaintenanceRecoveryStage failed due to HelixManager being null or not connected!");
            return;
        }
        MaintenanceSignal.AutoTriggerReason internalReason = maintenanceSignal.getAutoTriggerReason();
        switch (internalReason) {
            case MAX_OFFLINE_INSTANCES_EXCEEDED: {
                int numOfflineInstancesForAutoExit = cache.getClusterConfig().getNumOfflineInstancesForAutoExit();
                if (numOfflineInstancesForAutoExit < 0) {
                    return;
                }
                int offlineDisabledCount = cache.getAllInstances().size() - cache.getEnabledLiveInstances().size();
                shouldExitMaintenance = offlineDisabledCount <= numOfflineInstancesForAutoExit;
                reason = String.format("Auto-exiting maintenance mode for cluster %s; Num. of offline/disabled instances is %d, less than or equal to the exit threshold %d", event.getClusterName(), offlineDisabledCount, numOfflineInstancesForAutoExit);
                break;
            }
            case MAX_PARTITION_PER_INSTANCE_EXCEEDED: {
                IntermediateStateOutput intermediateStateOutput = (IntermediateStateOutput)event.getAttribute(AttributeName.INTERMEDIATE_STATE.name());
                if (intermediateStateOutput == null) {
                    return;
                }
                shouldExitMaintenance = !this.violatesMaxPartitionsPerInstance(cache, intermediateStateOutput);
                reason = String.format("Auto-exiting maintenance mode for cluster %s; All instances have fewer or equal number of partitions than maxPartitionsPerInstance threshold.", event.getClusterName());
                break;
            }
            default: {
                shouldExitMaintenance = false;
                reason = "";
            }
        }
        if (shouldExitMaintenance) {
            manager.getClusterManagmentTool().autoEnableMaintenanceMode(manager.getClusterName(), false, reason, internalReason);
            cache.setMaintenanceSignalChanged();
            LogUtil.logInfo(LOG, this._eventId, reason);
        }
    }

    private boolean violatesMaxPartitionsPerInstance(ResourceControllerDataProvider cache, IntermediateStateOutput intermediateStateOutput) {
        int maxPartitionPerInstance = cache.getClusterConfig().getMaxPartitionsPerInstance();
        if (maxPartitionPerInstance <= 0) {
            return false;
        }
        Map<String, PartitionStateMap> resourceStatesMap = intermediateStateOutput.getResourceStatesMap();
        HashMap<String, Integer> instancePartitionCounts = new HashMap<String, Integer>();
        for (String resource : resourceStatesMap.keySet()) {
            IdealState idealState = cache.getIdealState(resource);
            if (idealState != null && idealState.getStateModelDefRef().equals(BuiltInStateModelDefinitions.Task.name())) continue;
            PartitionStateMap partitionStateMap = resourceStatesMap.get(resource);
            Map<Partition, Map<String, String>> stateMaps = partitionStateMap.getStateMap();
            for (Partition p : stateMaps.keySet()) {
                Map<String, String> stateMap = stateMaps.get(p);
                for (String instance : stateMap.keySet()) {
                    String state = stateMap.get(instance);
                    if (state.equals(HelixDefinedState.DROPPED.name())) continue;
                    if (!instancePartitionCounts.containsKey(instance)) {
                        instancePartitionCounts.put(instance, 0);
                    }
                    int partitionCount = (Integer)instancePartitionCounts.get(instance);
                    if (++partitionCount > maxPartitionPerInstance) {
                        return true;
                    }
                    instancePartitionCounts.put(instance, partitionCount);
                }
            }
        }
        return false;
    }
}

