/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.examples;

import org.apache.helix.controller.HelixControllerMain;
import org.apache.helix.examples.DummyParticipant;
import org.apache.helix.manager.zk.ZKHelixAdmin;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.helix.manager.zk.client.HelixZkClient;
import org.apache.helix.manager.zk.client.SharedZkClientFactory;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.model.builder.CustomModeISBuilder;
import org.apache.helix.model.builder.FullAutoModeISBuilder;
import org.apache.helix.model.builder.IdealStateBuilder;
import org.apache.helix.model.builder.SemiAutoModeISBuilder;
import org.apache.helix.tools.StateModelConfigGenerator;

public class IdealStateBuilderExample {
    private static String buildPartitionName(String resourceName, int partitionNum) {
        return resourceName + "_" + partitionNum;
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.err.println("USAGE: java IdealStateBuilderExample zkAddress clusterName idealStateMode (FULL_AUTO, SEMI_AUTO, CUSTOMIZED, or USER_DEFINED)");
            System.exit(1);
        }
        final String zkAddr = args[0];
        final String clusterName = args[1];
        IdealState.RebalanceMode idealStateMode = IdealState.RebalanceMode.valueOf(args[2].toUpperCase());
        HelixZkClient.ZkClientConfig clientConfig = new HelixZkClient.ZkClientConfig();
        clientConfig.setZkSerializer(new ZNRecordSerializer());
        HelixZkClient zkClient = SharedZkClientFactory.getInstance().buildZkClient(new HelixZkClient.ZkConnectionConfig(zkAddr), clientConfig);
        ZKHelixAdmin admin = new ZKHelixAdmin(zkClient);
        admin.addCluster(clusterName, true);
        admin.addStateModelDef(clusterName, "MasterSlave", new StateModelDefinition(StateModelConfigGenerator.generateConfigForMasterSlave()));
        int n = 2;
        for (int i = 0; i < n; ++i) {
            int port = 12918 + i;
            InstanceConfig config = new InstanceConfig("localhost_" + port);
            config.setHostName("localhost");
            config.setPort(Integer.toString(port));
            config.setInstanceEnabled(true);
            admin.addInstance(clusterName, config);
        }
        String resourceName = "TestDB";
        IdealState idealState = null;
        switch (idealStateMode) {
            case SEMI_AUTO: {
                IdealStateBuilder builder = new SemiAutoModeISBuilder(resourceName);
                builder.setStateModel("MasterSlave").setNumPartitions(2).setNumReplica(2);
                ((SemiAutoModeISBuilder)builder).assignPreferenceList(IdealStateBuilderExample.buildPartitionName(resourceName, 0), "localhost_12918", "localhost_12919").assignPreferenceList(IdealStateBuilderExample.buildPartitionName(resourceName, 1), "localhost_12919", "localhost_12918");
                idealState = builder.build();
                break;
            }
            case FULL_AUTO: {
                IdealStateBuilder builder = new FullAutoModeISBuilder(resourceName);
                builder.setStateModel("MasterSlave").setNumPartitions(2).setNumReplica(2).setMaxPartitionsPerNode(2);
                ((FullAutoModeISBuilder)builder).add(IdealStateBuilderExample.buildPartitionName(resourceName, 0)).add(IdealStateBuilderExample.buildPartitionName(resourceName, 1));
                idealState = builder.build();
                break;
            }
            case CUSTOMIZED: {
                IdealStateBuilder builder = new CustomModeISBuilder(resourceName);
                builder.setStateModel("MasterSlave").setNumPartitions(2).setNumReplica(2);
                ((CustomModeISBuilder)builder).assignInstanceAndState(IdealStateBuilderExample.buildPartitionName(resourceName, 0), "localhost_12918", "MASTER").assignInstanceAndState(IdealStateBuilderExample.buildPartitionName(resourceName, 0), "localhost_12919", "SLAVE").assignInstanceAndState(IdealStateBuilderExample.buildPartitionName(resourceName, 1), "localhost_12918", "SLAVE").assignInstanceAndState(IdealStateBuilderExample.buildPartitionName(resourceName, 1), "localhost_12919", "MASTER");
                idealState = builder.build();
                break;
            }
        }
        admin.addResource(clusterName, resourceName, idealState);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    HelixControllerMain.main(new String[]{"--zkSvr", zkAddr, "--cluster", clusterName});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        for (int i = 0; i < n; ++i) {
            int port = 12918 + i;
            final String instanceName = "localhost_" + port;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    DummyParticipant.main(new String[]{zkAddr, clusterName, instanceName});
                }
            }).start();
        }
    }
}

